/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.zeith.hammerlib.annotations.OnlyIf;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.Setup;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.annotations.client.ClientSetup;
import org.zeith.hammerlib.api.blocks.ICustomBlockItem;
import org.zeith.hammerlib.api.blocks.IItemGroupBlock;
import org.zeith.hammerlib.api.blocks.IItemPropertySupplier;
import org.zeith.hammerlib.api.blocks.INoItemBlock;
import org.zeith.hammerlib.api.fml.IRegisterListener;
import org.zeith.hammerlib.core.adapter.OnlyIfAdapter;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.ReflectionUtil;

public class RegistryAdapter {
    private static final Map<Class<?>, List<Block>> blocks = new ConcurrentHashMap();

    public static <T extends IForgeRegistryEntry<T>> Consumer<T> createRegisterer(IForgeRegistry<T> registry) {
        return entry -> {
            IRegisterListener l = Cast.cast(entry, IRegisterListener.class);
            if (l != null) {
                l.onPreRegistered();
            }
            registry.register(entry);
            if (l != null) {
                l.onPostRegistered();
            }
        };
    }

    public static <T extends IForgeRegistryEntry<T>> int register(IForgeRegistry<T> registry, Class<?> source, String modid) {
        List blockList = blocks.computeIfAbsent(source, s -> new ArrayList());
        Consumer<IForgeRegistryEntry> grabber = RegistryAdapter.createRegisterer(registry).andThen(handler -> {
            if (handler instanceof Block) {
                blockList.add((Block)handler);
            }
        });
        if (Item.class.equals((Object)registry.getRegistrySuperType())) {
            for (Block blk : blockList) {
                BlockItem item;
                if (blk instanceof INoItemBlock) continue;
                IItemPropertySupplier gen = Cast.cast(blk, IItemPropertySupplier.class);
                if (blk instanceof ICustomBlockItem) {
                    item = ((ICustomBlockItem)blk).createBlockItem();
                } else {
                    Item.Properties props;
                    Item.Properties properties = props = gen != null ? gen.createItemProperties(new Item.Properties()) : new Item.Properties();
                    if (blk instanceof IItemGroupBlock) {
                        props = props.func_200916_a(((IItemGroupBlock)blk).getItemGroup());
                    }
                    item = new BlockItem(blk, props);
                }
                if (item.getRegistryName() == null) {
                    item.setRegistryName(blk.getRegistryName());
                }
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
            }
        }
        int prevSize = registry.getValues().size();
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(SimplyRegister.class) != null && m.getParameterCount() == 1 && Consumer.class.isAssignableFrom(m.getParameterTypes()[0]) && ReflectionUtil.doesParameterTypeArgsMatch(m.getParameters()[0], registry.getRegistrySuperType())).forEach(method -> {
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    OnlyIf onlyIf = method.getAnnotation(OnlyIf.class);
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), registry.getRegistrySuperType().getSimpleName(), null)) {
                        return;
                    }
                    method.setAccessible(true);
                    method.invoke(null, grabber);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
        Arrays.stream(source.getDeclaredFields()).filter(f -> registry.getRegistrySuperType().isAssignableFrom(f.getType())).forEach(field -> {
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())) {
                try {
                    field.setAccessible(true);
                    RegistryName name = field.getAnnotation(RegistryName.class);
                    OnlyIf onlyIf = field.getAnnotation(OnlyIf.class);
                    IForgeRegistryEntry t = (IForgeRegistryEntry)registry.getRegistrySuperType().cast(field.get(null));
                    if (name != null) {
                        t.setRegistryName(new ResourceLocation(modid, name.value()));
                    }
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), registry.getRegistrySuperType().getSimpleName(), t)) {
                        return;
                    }
                    grabber.accept(t);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        });
        return registry.getValues().size() - prevSize;
    }

    public static void setup(FMLCommonSetupEvent event, Class<?> source, String memberName) {
        String methodName = memberName.substring(0, memberName.indexOf(40));
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(Setup.class) != null && m.getName().equals(methodName)).forEach(method -> {
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    OnlyIf onlyIf = method.getAnnotation(OnlyIf.class);
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), "Setup", null)) {
                        return;
                    }
                    method.setAccessible(true);
                    if (method.getParameterCount() == 0) {
                        method.invoke(null, new Object[0]);
                    } else if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == FMLCommonSetupEvent.class) {
                        method.invoke(null, event);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    RuntimeException re = null;
                    if (e instanceof InvocationTargetException && e.getCause() instanceof RuntimeException) {
                        re = (RuntimeException)e.getCause();
                    }
                    if (e instanceof RuntimeException) {
                        re = (RuntimeException)e;
                    }
                    if (re != null) {
                        throw re;
                    }
                    e.printStackTrace();
                }
            }
        });
    }

    public static void clientSetup(FMLClientSetupEvent event, Class<?> source, String memberName) {
        String methodName = memberName.substring(0, memberName.indexOf(40));
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(ClientSetup.class) != null && m.getName().equals(methodName)).forEach(method -> {
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    OnlyIf onlyIf = method.getAnnotation(OnlyIf.class);
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), "ClientSetup", null)) {
                        return;
                    }
                    method.setAccessible(true);
                    if (method.getParameterCount() == 0) {
                        method.invoke(null, new Object[0]);
                    } else if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == FMLClientSetupEvent.class) {
                        method.invoke(null, event);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    RuntimeException re = null;
                    if (e instanceof InvocationTargetException && e.getCause() instanceof RuntimeException) {
                        re = (RuntimeException)e.getCause();
                    }
                    if (e instanceof RuntimeException) {
                        re = (RuntimeException)e;
                    }
                    if (re != null) {
                        throw re;
                    }
                    e.printStackTrace();
                }
            }
        });
    }
}

