/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.packets;

import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.PacketContext;

public class PingServerPacket
implements IPacket {
    public static long lastPingTime = 0L;
    long time;
    long lastPing;

    public PingServerPacket() {
    }

    public PingServerPacket(long time) {
        this.time = time;
        this.lastPing = lastPingTime;
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeLong(this.time);
        buf.writeLong(this.lastPing);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.time = buf.readLong();
        this.lastPing = buf.readLong();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientExecute(PacketContext ctx) {
        lastPingTime = (System.currentTimeMillis() - this.time) / 2L;
    }

    @Override
    public void serverExecute(PacketContext ctx) {
        ctx.withReply(this);
    }
}

