/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyVector3d
implements IProperty<Vector3d> {
    final DirectStorage<Vector3d> value;
    boolean changed;
    PropertyDispatcher dispatcher;

    public PropertyVector3d(DirectStorage<Vector3d> value) {
        this.value = value;
    }

    public PropertyVector3d() {
        this(DirectStorage.allocate());
    }

    @Override
    public Class<Vector3d> getType() {
        return Vector3d.class;
    }

    @Override
    public Vector3d set(Vector3d value) {
        Vector3d pv = this.value.get();
        if (!Objects.equals(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void write(PacketBuffer buf) {
        Vector3d value = this.value.get();
        buf.writeBoolean(value != null);
        if (value != null) {
            buf.writeDouble(value.field_72450_a);
            buf.writeDouble(value.field_72448_b);
            buf.writeDouble(value.field_72449_c);
        }
    }

    @Override
    public void read(PacketBuffer buf) {
        if (buf.readBoolean()) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            this.value.set(new Vector3d(x, y, z));
        } else {
            this.value.set(null);
        }
    }

    @Override
    public Vector3d get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

