/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;

public class XPUtil {
    public static int takeXP(PlayerEntity player, int xp) {
        int total = XPUtil.getXPTotal(player);
        int taken = Math.min(xp, total);
        XPUtil.setPlayersExpTo(player, total -= taken);
        return taken;
    }

    public static void giveXP(PlayerEntity player, int xp) {
        XPUtil.setPlayersExpTo(player, XPUtil.getXPTotal(player) + xp);
    }

    public static void setPlayersExpTo(PlayerEntity player, int total) {
        player.field_71068_ca = Math.max(XPUtil.getLevelFromXPValue(total), 0);
        player.field_71106_cc = Math.max(XPUtil.getCurrentFromXPValue(total), 0.0f);
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetExperiencePacket(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        }
    }

    public static int getXPTotal(int xpLevel, float current) {
        return (int)((float)XPUtil.getXPValueFromLevel(xpLevel) + (float)XPUtil.getXPValueToNextLevel(xpLevel) * current);
    }

    public static int getXPTotal(PlayerEntity player) {
        return (int)((float)XPUtil.getXPValueFromLevel(player.field_71068_ca) + (float)XPUtil.getXPValueToNextLevel(player.field_71068_ca) * player.field_71106_cc);
    }

    public static int getLevelFromXPValue(int value) {
        int level = 0;
        level = value >= XPUtil.getXPValueFromLevel(30) ? (int)(0.07142857142857142 * (Math.sqrt(56.0 * (double)value - 32511.0) + 303.0)) : (value >= XPUtil.getXPValueFromLevel(15) ? (int)(0.16666666666666666 * (Math.sqrt(24.0 * (double)value - 5159.0) + 59.0)) : (int)((double)value / 17.0));
        return level;
    }

    public static float getCurrentFromXPValue(int value) {
        if (value == 0) {
            return 0.0f;
        }
        int level = XPUtil.getLevelFromXPValue(value);
        float needed = XPUtil.getXPValueFromLevel(level);
        float next = XPUtil.getXPValueToNextLevel(level);
        float difference = (float)value - needed;
        float current = difference / next;
        return current;
    }

    public static int getXPValueFromLevel(int xpLevel) {
        int val = 0;
        val = xpLevel >= 30 ? (int)(3.5 * Math.pow(xpLevel, 2.0) - 151.5 * (double)xpLevel + 2220.0) : (xpLevel >= 15 ? (int)(1.5 * Math.pow(xpLevel, 2.0) - 29.5 * (double)xpLevel + 360.0) : 17 * xpLevel);
        return val;
    }

    public static int getXPValueToNextLevel(int xpLevel) {
        int val = 0;
        val = xpLevel >= 30 ? 7 * xpLevel - 148 : (xpLevel >= 15 ? 3 * xpLevel - 28 : 17);
        return val;
    }
}

