/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.cfg.entries;

import java.util.Objects;
import org.zeith.hammerlib.util.cfg.ConfigEntrySerializer;
import org.zeith.hammerlib.util.cfg.ConfigFile;
import org.zeith.hammerlib.util.cfg.IConfigEntry;

public class ConfigEntryString
implements IConfigEntry {
    final ConfigFile cfg;
    String description;
    String name;
    String value;
    String initialValue;

    public ConfigEntryString(ConfigFile cfg, String initialValue) {
        this.value = initialValue;
        this.initialValue = initialValue;
        this.cfg = cfg;
    }

    public ConfigEntryString setDescription(String description) {
        this.description = description;
        return this;
    }

    public ConfigEntryString setName(String name) {
        if (!Objects.equals(name, this.name)) {
            this.name = name;
            this.cfg.markChanged();
        }
        return this;
    }

    public ConfigEntryString setValue(String value) {
        if (!Objects.equals(value, this.value)) {
            this.value = value;
            this.cfg.markChanged();
        }
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (this.value == null) {
            this.setValue(this.initialValue);
        }
        return this.value;
    }

    @Override
    public ConfigEntrySerializer<?> getSerializer() {
        return ConfigFile.SERIALIZER_STRING;
    }
}

