/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import org.zeith.hammerlib.util.configured.ConfigToken;
import org.zeith.hammerlib.util.configured.io.IoNewLiner;
import org.zeith.hammerlib.util.configured.io.StringReader;
import org.zeith.hammerlib.util.configured.io.buf.IByteBuf;
import org.zeith.hammerlib.util.configured.types.ConfigElement;

public class ConfigString
extends ConfigElement<ConfigString> {
    protected String defaultValue;
    protected String value;

    public ConfigString(Runnable onChanged, ConfigToken<ConfigString> token, String name) {
        super(onChanged, token, name);
    }

    public ConfigString withDefault(String string) {
        this.defaultValue = string;
        return this;
    }

    @Override
    public String getValue() {
        return this.value != null ? this.value : this.defaultValue;
    }

    @Override
    public boolean read(BufferedReader reader, int depth, String readerStack) throws IOException {
        this.value = StringReader.readName(reader, c -> c == 13 || c == 10);
        return true;
    }

    @Override
    public void write(BufferedWriter writer, IoNewLiner newLiner) throws IOException {
        StringReader.writeName(writer, this.getValue(), c -> true);
    }

    @Override
    public void toBuffer(IByteBuf buf) {
        buf.writeString(this.getValue());
    }

    @Override
    public void fromBuffer(IByteBuf buf) {
        this.value = buf.readString();
    }

    public String toString() {
        return "ConfigString{defaultValue='" + this.defaultValue + '\'' + ", value='" + this.value + '\'' + ", name='" + this.name + '\'' + ", comment='" + this.getEscapedComment() + '\'' + '}';
    }
}

