/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.Fetcher;
import org.zeith.hammerlib.util.java.ReflectionUtil;

public class ScanDataHelper {
    public static <T> List<Class<? extends T>> lookupAnnotatedTypes(Class<? extends Annotation> annotation, Class<T> baseType) {
        return ScanDataHelper.lookupAnnotatedTypes(annotation, baseType, (Predicate<ModFileScanData.AnnotationData>)Predicates.alwaysTrue());
    }

    public static <T> List<Class<? extends T>> lookupAnnotatedTypes(Class<? extends Annotation> annotation, Class<T> baseType, Predicate<ModFileScanData.AnnotationData> matcher) {
        ArrayList classes = new ArrayList();
        ScanDataHelper.lookupAnnotatedObjects(annotation, (ModFileScanData.AnnotationData ad) -> ad.getTargetType() == ElementType.TYPE && baseType.isAssignableFrom(ReflectionUtil.fetchClass(ad.getClassType())) && matcher.test((ModFileScanData.AnnotationData)ad)).forEach(ad -> classes.add(ReflectionUtil.fetchClass(ad.getClassType())));
        return classes;
    }

    public static Collection<ModAwareAnnotationData> lookupAnnotatedObjects(Class<? extends Annotation> annotation) {
        return ScanDataHelper.lookupAnnotatedObjects(annotation, (Predicate<ModFileScanData.AnnotationData>)Predicates.alwaysTrue());
    }

    public static Collection<ModAwareAnnotationData> lookupAnnotatedObjects(Class<? extends Annotation> annotation, Predicate<ModFileScanData.AnnotationData> matcher) {
        ArrayList<ModAwareAnnotationData> data = new ArrayList<ModAwareAnnotationData>();
        Type annotationType = Type.getType(annotation);
        ModList.get().getAllScanData().stream().flatMap(d -> d.getAnnotations().stream().map(ad -> new ModAwareAnnotationData((ModFileScanData.AnnotationData)ad, (ModFileScanData)d))).filter(ad -> annotationType.equals((Object)ad.getAnnotationType()) && matcher.test((ModFileScanData.AnnotationData)ad)).forEach(data::add);
        return data;
    }

    public static Collection<ModAwareAnnotationData> lookupAnnotatedObjects(ModFileScanData data, Class<? extends Annotation> annotation) {
        return ScanDataHelper.lookupAnnotatedObjects(data, annotation, (Predicate<ModFileScanData.AnnotationData>)Predicates.alwaysTrue());
    }

    public static Collection<ModAwareAnnotationData> lookupAnnotatedObjects(ModFileScanData data, Class<? extends Annotation> annotation, Predicate<ModFileScanData.AnnotationData> matcher) {
        ArrayList<ModAwareAnnotationData> lst = new ArrayList<ModAwareAnnotationData>();
        Type annotationType = Type.getType(annotation);
        Stream.of(data).flatMap(d -> d.getAnnotations().stream().map(ad -> new ModAwareAnnotationData((ModFileScanData.AnnotationData)ad, (ModFileScanData)d))).filter(ad -> annotationType.equals((Object)ad.getAnnotationType()) && matcher.test((ModFileScanData.AnnotationData)ad)).forEach(lst::add);
        return lst;
    }

    public static ScanProperties properties(Object ... keyValuePairs) {
        return new ScanProperties(keyValuePairs);
    }

    public static class ModAwareAnnotationData
    extends ModFileScanData.AnnotationData {
        private final ModFileScanData modFile;
        private Fetcher<Optional<FMLModContainer>> ownerMod;

        public ModAwareAnnotationData(ModFileScanData.AnnotationData parent, ModFileScanData modFile) {
            super(parent.getAnnotationType(), parent.getTargetType(), parent.getClassType(), parent.getMemberName(), parent.getAnnotationData());
            this.modFile = modFile;
        }

        public Optional<FMLModContainer> getOwnerMod() {
            if (this.ownerMod == null) {
                this.ownerMod = Fetcher.fetchOnce(() -> this.modFile.getIModInfoData().stream().flatMap(inf -> inf.getMods().stream()).map(IModInfo::getModId).map(arg_0 -> ((ModList)ModList.get()).getModContainerById(arg_0)).map(modopt -> modopt.orElse(null)).filter((Predicate<ModContainer>)Predicates.instanceOf(FMLModContainer.class)).findFirst().map(FMLModContainer.class::cast));
            }
            return this.ownerMod.get();
        }

        public ModFileScanData getModFile() {
            return this.modFile;
        }

        public Class<?> getOwnerClass() {
            return ReflectionUtil.fetchClass(this.getClassType());
        }

        public Optional<Object> getProperty(String key) {
            Map map = this.getAnnotationData();
            return map.containsKey(key) ? Optional.ofNullable(map.get(key)) : Optional.empty();
        }
    }

    public static class ScanProperties
    implements Predicate<ModFileScanData.AnnotationData> {
        private final Map<String, Object> entries;

        public ScanProperties(Object ... keyValuePairs) {
            if (keyValuePairs.length % 2 != 0) {
                throw new IllegalArgumentException("Odd amount of key & value pairs!");
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < keyValuePairs.length; i += 2) {
                String key = Cast.cast(keyValuePairs[i], String.class);
                Object value = keyValuePairs[i + 1];
                if (key == null) {
                    throw new NullPointerException("Key argument @" + i + " is " + (keyValuePairs[i] == null ? "null" : "not a string") + "!");
                }
                builder.put((Object)key, value);
            }
            this.entries = builder.build();
        }

        public boolean matches(Map<String, Object> data) {
            if (this.entries.size() > data.size()) {
                return false;
            }
            for (String key : this.entries.keySet()) {
                if (!data.containsKey(key)) {
                    return false;
                }
                if (Objects.equals(this.entries.get(key), data.get(key))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean test(ModFileScanData.AnnotationData t) {
            return this.matches(t.getAnnotationData());
        }
    }
}

