/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.item.crafting;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xerca.xercapaint.common.item.Items;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RecipeCraftPalette
extends SpecialRecipe {
    public RecipeCraftPalette(ResourceLocation p_i48170_1_) {
        super(p_i48170_1_);
    }

    private boolean isPlank(ItemStack stack) {
        return stack.func_77973_b().getTags().contains(new ResourceLocation("minecraft:planks"));
    }

    private boolean isDye(ItemStack stack) {
        return stack.func_77973_b() instanceof DyeItem;
    }

    private boolean isPlankRow(CraftingInventory inv, int row) {
        int plankCount = 0;
        for (int j = 0; j < inv.func_174922_i(); ++j) {
            int id = row * inv.func_174922_i() + j;
            ItemStack stack = inv.func_70301_a(id);
            if (!this.isPlank(stack)) continue;
            ++plankCount;
        }
        return plankCount == 3;
    }

    private int findPlankRow(CraftingInventory inv) {
        for (int i = 0; i < inv.func_174923_h(); ++i) {
            if (!this.isPlankRow(inv, i)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private ArrayList<ItemStack> findDyes(CraftingInventory inv, int plankRow) {
        ArrayList<ItemStack> dyes = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_174923_h(); ++i) {
            if (i == plankRow) continue;
            for (int j = 0; j < inv.func_174922_i(); ++j) {
                int id = i * inv.func_174922_i() + j;
                ItemStack stack = inv.func_70301_a(id);
                if (this.isDye(stack)) {
                    dyes.add(stack);
                    continue;
                }
                if (stack.func_190926_b()) continue;
                return null;
            }
        }
        return dyes;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        int plankRow = this.findPlankRow(inv);
        if (plankRow < 0) {
            return false;
        }
        ArrayList<ItemStack> dyes = this.findDyes(inv, plankRow);
        return dyes != null && !dyes.isEmpty();
    }

    public ItemStack assemble(CraftingInventory inv) {
        int plankRow = this.findPlankRow(inv);
        if (plankRow < 0) {
            return ItemStack.field_190927_a;
        }
        ArrayList<ItemStack> dyes = this.findDyes(inv, plankRow);
        if (dyes == null || dyes.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        byte[] basicColors = new byte[16];
        for (ItemStack dye : dyes) {
            DyeColor color = ((DyeItem)dye.func_77973_b()).func_195962_g();
            basicColors[15 - color.func_196059_a()] = 1;
        }
        ItemStack result = new ItemStack((IItemProvider)Items.ITEM_PALETTE);
        CompoundNBT tag = result.func_196082_o();
        tag.func_74773_a("basic", basicColors);
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        return list;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Items.CRAFTING_SPECIAL_PALETTE_CRAFTING;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }
}

