/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.util.Arrays;
import net.minecraft.network.PacketBuffer;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.entity.EntityEasel;

public class CanvasMiniUpdatePacket {
    private int[] pixels;
    private CanvasType canvasType;
    private String name;
    private int version;
    private int easelId;
    private boolean messageIsValid;

    public CanvasMiniUpdatePacket(int[] pixels, String name, int version, EntityEasel easel, CanvasType canvasType) {
        this.name = name;
        this.version = version;
        this.canvasType = canvasType;
        int area = CanvasType.getHeight(canvasType) * CanvasType.getWidth(canvasType);
        this.pixels = Arrays.copyOfRange(pixels, 0, area);
        this.easelId = easel == null ? -1 : easel.func_145782_y();
    }

    public CanvasMiniUpdatePacket() {
        this.messageIsValid = false;
    }

    public static void encode(CanvasMiniUpdatePacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.easelId);
        buf.writeByte(pkt.canvasType.ordinal());
        buf.writeInt(pkt.version);
        buf.func_180714_a(pkt.name);
        buf.func_186875_a(pkt.pixels);
    }

    public static CanvasMiniUpdatePacket decode(PacketBuffer buf) {
        CanvasMiniUpdatePacket result = new CanvasMiniUpdatePacket();
        try {
            result.easelId = buf.readInt();
            result.canvasType = CanvasType.fromByte(buf.readByte());
            result.version = buf.readInt();
            result.name = buf.func_150789_c(64);
            int area = CanvasType.getHeight(result.canvasType) * CanvasType.getWidth(result.canvasType);
            result.pixels = buf.func_189424_c(area);
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading CanvasUpdatePacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public int getVersion() {
        return this.version;
    }

    public int getEaselId() {
        return this.easelId;
    }

    public CanvasType getCanvasType() {
        return this.canvasType;
    }
}

