/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.network.NetworkEvent;
import xerca.xercapaint.common.PaletteUtil;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.EntityEasel;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.item.Items;
import xerca.xercapaint.common.packets.CanvasUpdatePacket;

public class CanvasUpdatePacketHandler {
    public static void handle(CanvasUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when CanvasUpdatePacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> CanvasUpdatePacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void processMessage(CanvasUpdatePacket msg, ServerPlayerEntity pl) {
        ItemStack palette;
        ItemStack canvas;
        Entity entityEasel = null;
        if (msg.getEaselId() > -1) {
            entityEasel = pl.field_70170_p.func_73045_a(msg.getEaselId());
            if (entityEasel == null) {
                XercaPaint.LOGGER.error("CanvasUpdatePacketHandler: Easel entity not found! easelId: " + msg.getEaselId());
                return;
            }
            if (!(entityEasel instanceof EntityEasel)) {
                XercaPaint.LOGGER.error("CanvasUpdatePacketHandler: Entity found is not an easel! easelId: " + msg.getEaselId());
                return;
            }
            EntityEasel easel = (EntityEasel)entityEasel;
            canvas = easel.getItem();
            if (!(canvas.func_77973_b() instanceof ItemCanvas)) {
                XercaPaint.LOGGER.error("CanvasUpdatePacketHandler: Canvas not found inside easel!");
                return;
            }
            ItemStack mainHandItem = pl.func_184614_ca();
            ItemStack offHandItem = pl.func_184592_cb();
            if (mainHandItem.func_77973_b() instanceof ItemPalette) {
                palette = mainHandItem;
            } else {
                if (!(offHandItem.func_77973_b() instanceof ItemPalette)) {
                    XercaPaint.LOGGER.error("CanvasUpdatePacketHandler: Palette not found on player's hands!");
                    return;
                }
                palette = offHandItem;
            }
        } else {
            canvas = pl.func_184614_ca();
            palette = pl.func_184592_cb();
            if (canvas.func_77973_b() instanceof ItemPalette) {
                ItemStack temp = canvas;
                canvas = palette;
                palette = temp;
            }
        }
        if (!canvas.func_190926_b() && canvas.func_77973_b() instanceof ItemCanvas) {
            CompoundNBT comp = canvas.func_196082_o();
            comp.func_74783_a("pixels", msg.getPixels());
            comp.func_74778_a("name", msg.getName());
            comp.func_74768_a("v", msg.getVersion());
            comp.func_74768_a("generation", 0);
            if (msg.getSigned()) {
                comp.func_74778_a("author", pl.func_200200_C_().getString());
                comp.func_74778_a("title", msg.getTitle().trim());
                comp.func_74768_a("generation", 1);
            }
            if (!palette.func_190926_b() && palette.func_77973_b() == Items.ITEM_PALETTE) {
                CompoundNBT paletteComp = palette.func_196082_o();
                PaletteUtil.writeCustomColorArrayToNBT(paletteComp, msg.getPaletteColors());
            }
            if (entityEasel instanceof EntityEasel) {
                EntityEasel easel = (EntityEasel)entityEasel;
                easel.setItem(canvas, false);
                easel.setPainter(null);
            }
            XercaPaint.LOGGER.debug("Handling canvas update: Name: " + msg.getName() + " V: " + msg.getVersion());
        }
    }
}

