/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import xerca.xercapaint.client.ClientStuff;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.EntityEasel;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.packets.OpenGuiPacket;

public class OpenGuiPacketHandler {
    public static void handle(OpenGuiPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ctx.get().enqueueWork(() -> OpenGuiPacketHandler.processMessage(message));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processMessage(OpenGuiPacket msg) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (msg.isAllowed()) {
            Entity entity = player.field_70170_p.func_73045_a(msg.getEaselId());
            if (entity instanceof EntityEasel) {
                EntityEasel easel = (EntityEasel)entity;
                ItemStack itemInHand = player.func_184586_b(msg.getHand());
                boolean handHoldsPalette = itemInHand.func_77973_b() instanceof ItemPalette;
                if (msg.isEdit()) {
                    if (handHoldsPalette) {
                        ClientStuff.showCanvasGui(easel, itemInHand);
                    } else {
                        XercaPaint.LOGGER.error("Could not find palette in hand for editing painting");
                    }
                } else {
                    ClientStuff.showCanvasGui(easel, ItemStack.field_190927_a);
                }
            } else {
                XercaPaint.LOGGER.error("Could not find easel");
            }
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("easel.deny").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        }
    }
}

