/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore;

import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.StandardConfigFile;
import java.nio.file.Paths;
import java.util.function.Consumer;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.ArrayUtils;

public class BCConfig {
    private static ConfigTag config;
    private static ConfigTag clientTag;
    private static ConfigTag serverTag;
    public static boolean enable_tpx;
    public static boolean clientPermissionVerification;
    @Deprecated
    public static boolean devLog;
    public static boolean darkMode;
    public static boolean useShaders;

    public static void load() {
        config = new StandardConfigFile(Paths.get("./config/brandon3055/BrandonsCore.cfg", new String[0])).load();
        BCConfig.loadServer();
        BCConfig.loadClient();
        config.runSync();
        config.save();
    }

    private static void loadServer() {
        serverTag = config.getTag("Server");
        serverTag.getTag("enable_tpx").setComment("Allows you to disable the tpx command.").setDefaultBoolean(!ModList.get().isLoaded("mystcraft")).setSyncCallback((tag, type) -> {
            enable_tpx = tag.getBoolean();
        });
        serverTag.getTag("clientPermissionVerification").setComment(new String[]{"Uses the right click block event to verify that players have permission to interact with BC / DE blocks.", "This ensures there is no possible way a player can interact with a BC block if a protection system is blocking the interaction", "In theory not even a modified client sending raw packets will be able to bypass this.", "I have added the ability to disable this feature because it seems in rare cases it blocks players who should have access and i have no idea why."}).setDefaultBoolean(true).setSyncCallback((tag, type) -> {
            clientPermissionVerification = tag.getBoolean();
        });
    }

    private static void loadClient() {
        clientTag = config.getTag("Client");
        clientTag.getTag("darkMode").setComment("Enable / Disable dark mode in my GUI's. (This can also be toggled in game from any gui that supports dark mode)").setDefaultBoolean(true).setSyncCallback((tag, type) -> {
            darkMode = tag.getBoolean();
        });
        clientTag.getTag("useShaders").setComment("Set this to false if your system can not handle the awesomeness that is shaders! (Warning: Will make cool things look much less cool!)").setDefaultBoolean(true).setSyncCallback((tag, type) -> {
            useShaders = tag.getBoolean();
        });
    }

    private static void modifyProperty(String name, Consumer<ConfigTag> modifyCallback, String ... groupPath) {
        ConfigTag parent = config;
        for (String group : groupPath) {
            parent = parent.getTag(group);
        }
        ConfigTag tag = parent.getTag(name);
        modifyCallback.accept(tag);
        tag.runSync();
        tag.save();
    }

    public static void modifyClientProperty(String name, Consumer<ConfigTag> modifyCallback, String ... groupPath) {
        BCConfig.modifyProperty(name, modifyCallback, (String[])ArrayUtils.addAll((Object[])new String[]{"Client"}, (Object[])groupPath));
    }

    public static void modifyServerProperty(String name, Consumer<ConfigTag> modifyCallback, String ... groupPath) {
        BCConfig.modifyProperty(name, modifyCallback, (String[])ArrayUtils.addAll((Object[])new String[]{"Server"}, (Object[])groupPath));
    }

    public static void modifyCommonProperty(String name, Consumer<ConfigTag> modifyCallback, String ... groupPath) {
        BCConfig.modifyProperty(name, modifyCallback, (String[])ArrayUtils.addAll((Object[])new String[]{"Common"}, (Object[])groupPath));
    }
}

