/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api.hud;

import com.brandon3055.brandonscore.api.math.Vector2;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiPopUpDialogBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class AbstractHudElement
extends ForgeRegistryEntry<AbstractHudElement> {
    protected Vector2 rawPos;
    protected double width = 100.0;
    protected double height = 20.0;
    protected boolean enabled = true;
    protected double dragXOffset = 0.0;
    protected double dragYOffset = 0.0;
    private Runnable changeListener = null;

    public AbstractHudElement(Vector2 defaultRawPos) {
        this.rawPos = defaultRawPos;
    }

    public double width() {
        return this.width;
    }

    public double height() {
        return this.height;
    }

    public abstract void tick(boolean var1);

    public abstract void render(MatrixStack var1, float var2, boolean var3);

    public boolean shouldRender(RenderGameOverlayEvent.ElementType type, boolean preRenderEvent) {
        Minecraft mc = Minecraft.func_71410_x();
        return preRenderEvent && type == RenderGameOverlayEvent.ElementType.ALL;
    }

    public void addConfigElements(List<GuiElement<?>> list, GuiElement<?> parent) {
        list.add(this.createButton(() -> I18n.func_135052_a((String)("gui.brandonscore.hud_config.enabled." + this.enabled), (Object[])new Object[0]), parent, this.runDirty(() -> {
            this.enabled = !this.enabled;
        })));
    }

    protected GuiButton createButton(Supplier<String> textSupplier, @Nullable GuiElement<?> parent, @Nullable Runnable onPressed) {
        GuiButton button = new GuiButton();
        button.setDisplaySupplier(textSupplier);
        if (onPressed != null) {
            button.onReleased(onPressed);
        }
        if (parent != null) {
            parent.addChild(button);
        }
        button.setSize(120, 12);
        button.setInsets(0, 0, 0, 0);
        button.setRectFillColourGetter((hovering, disabled) -> hovering ? -12100758 : -15395563);
        return button;
    }

    protected GuiButton createButton(Supplier<String> textSupplier, @Nullable GuiElement<?> parent) {
        return this.createButton(textSupplier, parent, null);
    }

    public GuiElement<?> createConfigDialog(GuiElement<?> parentElement) {
        GuiPopUpDialogBase.PopoutDialog dialog = (GuiPopUpDialogBase.PopoutDialog)new GuiPopUpDialogBase.PopoutDialog(parentElement).setCloseOnOutsideClick(false);
        dialog.setPreDrawCallback((minecraft, mouseX, mouseY, partialTicks, mouseOver) -> {
            IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            GuiHelper.drawHoverRect((IRenderTypeBuffer)getter, new MatrixStack(), dialog.xPos(), dialog.yPos(), dialog.xSize(), dialog.ySize(), -15728624, 0x500000FF, false);
            getter.func_228461_a_();
        });
        ArrayList list = new ArrayList();
        this.addConfigElements(list, dialog);
        int yPos = dialog.yPos() + 3;
        int maxWidth = 0;
        for (GuiElement guiElement : list) {
            guiElement.setPos(dialog.xPos() + 3, yPos);
            maxWidth = Math.max(maxWidth, guiElement.xSize());
            yPos += guiElement.ySize();
        }
        for (GuiElement guiElement : list) {
            guiElement.setXSize(maxWidth);
        }
        Rectangle rect = dialog.getEnclosingRect();
        dialog.setSize(rect.width + 3, rect.height + 3);
        return dialog;
    }

    protected Runnable runDirty(Runnable run) {
        return () -> {
            run.run();
            this.markDirty();
        };
    }

    public double xPos() {
        int screen = this.screenWidth();
        double pos = (double)screen * this.rawPos.x;
        return (int)(pos -= this.width() * this.rawPos.x);
    }

    public double yPos() {
        int screen = this.screenHeight();
        double pos = (double)screen * this.rawPos.y;
        return (int)(pos -= this.height() * this.rawPos.y);
    }

    public int screenWidth() {
        return Minecraft.func_71410_x().func_228018_at_().func_198107_o();
    }

    public int screenHeight() {
        return Minecraft.func_71410_x().func_228018_at_().func_198087_p();
    }

    public void writeNBT(CompoundNBT nbt) {
        nbt.func_74757_a("enabled", this.enabled);
        nbt.func_74780_a("pos_x", this.rawPos.x);
        nbt.func_74780_a("pos_y", this.rawPos.y);
    }

    public void readNBT(CompoundNBT nbt) {
        this.enabled = nbt.func_74767_n("enabled");
        this.rawPos.x = nbt.func_74769_h("pos_x");
        this.rawPos.y = nbt.func_74769_h("pos_y");
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
    }

    public void markDirty() {
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    public void startMoving(double mouseX, double mouseY) {
        this.dragXOffset = (double)((int)mouseX) - this.xPos();
        this.dragYOffset = (double)((int)mouseY) - this.yPos();
    }

    public void onDragged(double mouseX, double mouseY) {
        double xMove = (int)(mouseX - this.dragXOffset - this.xPos());
        double yMove = (int)(mouseY - this.dragYOffset - this.yPos());
        this.rawPos.x = MathHelper.func_151237_a((double)(this.rawPos.x + xMove / (double)this.screenWidth()), (double)0.0, (double)1.0);
        this.rawPos.y = MathHelper.func_151237_a((double)(this.rawPos.y + yMove / (double)this.screenHeight()), (double)0.0, (double)1.0);
    }

    public void stopMoving() {
        this.markDirty();
    }

    public AbstractHudElement setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
}

