/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.api.power;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.api.power.IOInfo;
import com.brandon3055.brandonscore.api.power.IOPStorageModifiable;
import com.brandon3055.brandonscore.api.power.IOTracker;
import com.brandon3055.brandonscore.api.power.IOTrackerSelfTimed;
import com.brandon3055.brandonscore.lib.IMCDataSerializable;
import com.brandon3055.brandonscore.lib.IValueHashable;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class OPStorage
implements INBTSerializable<CompoundNBT>,
IValueHashable<ComparableValue>,
IMCDataSerializable,
IOPStorageModifiable {
    protected long energy;
    protected long capacity;
    protected long maxReceive;
    protected long maxExtract;
    protected IOTracker ioTracker;
    protected boolean allowExtract = true;
    protected boolean allowReceive = true;

    public OPStorage(long capacity) {
        this(capacity, capacity);
    }

    public OPStorage(long capacity, long maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0L);
    }

    public OPStorage(long capacity, long maxReceive, long maxExtract) {
        this(capacity, maxReceive, maxExtract, 0L);
    }

    public OPStorage(long capacity, long maxReceive, long maxExtract, long energy) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.energy = energy;
    }

    public OPStorage setIOMode(boolean allowExtract, boolean allowReceive) {
        this.allowExtract = allowExtract;
        this.allowReceive = allowReceive;
        return this;
    }

    public OPStorage setExtractOnly() {
        return this.setIOMode(true, false);
    }

    public OPStorage setReceiveOnly() {
        return this.setIOMode(false, true);
    }

    public OPStorage setIOMode(boolean inputOutput) {
        return this.setIOMode(!inputOutput, inputOutput);
    }

    @Override
    public long receiveOP(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        long energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
            if (this.ioTracker != null) {
                this.ioTracker.energyInserted(energyReceived);
            }
        }
        return energyReceived;
    }

    @Override
    public long extractOP(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
            if (this.ioTracker != null) {
                this.ioTracker.energyExtracted(energyExtracted);
            }
        }
        return energyExtracted;
    }

    @Override
    public long getOPStored() {
        return this.energy;
    }

    @Override
    public long getMaxOPStored() {
        return this.capacity;
    }

    @Override
    public boolean canExtract() {
        return this.allowExtract && this.maxExtract > 0L;
    }

    @Override
    public boolean canReceive() {
        return this.allowReceive && this.maxReceive > 0L;
    }

    @Override
    public long modifyEnergyStored(long amount) {
        if (amount > this.capacity - this.energy) {
            amount = this.capacity - this.energy;
        } else if (amount < -this.energy) {
            amount = -this.energy;
        }
        this.energy += amount;
        if (this.ioTracker != null) {
            this.ioTracker.energyModified(amount);
        }
        return Math.abs(amount);
    }

    @Override
    public long maxExtract() {
        return this.maxExtract > 0L ? this.maxExtract : this.maxReceive;
    }

    @Override
    public long maxReceive() {
        return this.maxReceive > 0L ? this.maxReceive : this.maxExtract;
    }

    public OPStorage setCapacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    public OPStorage setMaxExtract(long maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public long getMaxExtract() {
        return this.maxExtract;
    }

    public OPStorage setMaxReceive(long maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public long getMaxReceive() {
        return this.maxReceive;
    }

    public OPStorage setMaxTransfer(long maxTransfer) {
        this.maxReceive = this.maxExtract = maxTransfer;
        return this;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        this.smartWrite("energy", this.energy, compound);
        return compound;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.energy = this.smartRead("energy", nbt);
    }

    private void smartWrite(String name, long value, CompoundNBT compound) {
        if (value > Integer.MAX_VALUE) {
            compound.func_74772_a(name, value);
        } else {
            compound.func_74768_a(name, (int)value);
        }
    }

    private long smartRead(String name, CompoundNBT compound) {
        INBT tag = compound.func_74781_a(name);
        if (tag instanceof NumberNBT) {
            return ((NumberNBT)tag).func_150291_c();
        }
        return 0L;
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        output.writeVarLong(this.energy);
        output.writeVarLong(this.capacity);
        output.writeVarLong(this.maxReceive);
        output.writeVarLong(this.maxExtract);
        output.writeBoolean(this.ioTracker != null);
        if (this.ioTracker != null) {
            output.writeVarLong(this.ioTracker.currentInput());
            output.writeVarLong(this.ioTracker.currentOutput());
        }
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        this.energy = input.readVarLong();
        this.capacity = input.readVarLong();
        this.maxReceive = input.readVarLong();
        this.maxExtract = input.readVarLong();
        if (input.readBoolean()) {
            if (this.ioTracker == null) {
                this.ioTracker = new IOTrackerSelfTimed();
            }
            this.ioTracker.syncClientValues(input.readVarLong(), input.readVarLong());
        } else if (this.ioTracker != null) {
            this.ioTracker = null;
        }
    }

    @Override
    public ComparableValue getValueHash() {
        return new ComparableValue(this);
    }

    @Override
    public boolean checkValueHash(Object vh) {
        if (vh instanceof ComparableValue) {
            boolean mainCheck;
            ComparableValue v = (ComparableValue)vh;
            boolean bl = mainCheck = v.energy == this.energy && v.capacity == this.capacity && v.maxExtract == this.maxExtract && v.maxReceive == this.maxReceive;
            if (this.ioTracker != null) {
                return mainCheck && v.currentInput == this.ioTracker.currentInput() && v.currentOutput == this.ioTracker.currentOutput();
            }
            return mainCheck;
        }
        return false;
    }

    public void setIOTracker(@Nullable IOTracker ioTracker) {
        this.ioTracker = ioTracker;
    }

    @Override
    @Nullable
    public IOInfo getIOInfo() {
        return this.ioTracker;
    }

    protected static class ComparableValue {
        private final long energy;
        private final long capacity;
        private final long maxReceive;
        private final long maxExtract;
        private long currentInput = 0L;
        private long currentOutput = 0L;

        public ComparableValue(OPStorage storage) {
            this.energy = storage.energy;
            this.capacity = storage.capacity;
            this.maxReceive = storage.maxReceive;
            this.maxExtract = storage.maxExtract;
            if (storage.ioTracker != null) {
                this.currentInput = storage.ioTracker.currentInput();
                this.currentOutput = storage.ioTracker.currentOutput();
            }
        }
    }
}

