/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.IDataRetainingTile;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.IOTracker;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileCapabilityManager;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.inventory.ContainerBCore;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IDataManagerProvider;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.TileDataManager;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.items.IItemHandler;

public class TileBCore
extends TileEntity
implements IDataManagerProvider,
IDataRetainingTile,
INameable {
    protected boolean playerAccessTracking = false;
    protected TileCapabilityManager capManager = new TileCapabilityManager(this);
    protected TileDataManager<TileBCore> dataManager = new TileDataManager<TileBCore>(this);
    private Map<Integer, BiConsumer<MCDataInput, ServerPlayerEntity>> serverPacketHandlers = new HashMap<Integer, BiConsumer<MCDataInput, ServerPlayerEntity>>();
    protected Map<String, INBTSerializable<CompoundNBT>> savedItemDataObjects = new HashMap<String, INBTSerializable<CompoundNBT>>();
    protected Map<String, INBTSerializable<CompoundNBT>> savedDataObjects = new HashMap<String, INBTSerializable<CompoundNBT>>();
    private Map<Integer, Consumer<MCDataInput>> clientPacketHandlers = new HashMap<Integer, Consumer<MCDataInput>>();
    private List<Runnable> tickables = new ArrayList<Runnable>();
    private ManagedEnum<IRSSwitchable.RSMode> rsControlMode = this instanceof IRSSwitchable ? this.register(new ManagedEnum<IRSSwitchable.RSMode>("rs_mode", IRSSwitchable.RSMode.ALWAYS_ACTIVE, DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.CLIENT_CONTROL)) : null;
    private ManagedBool rsPowered = this instanceof IRSSwitchable ? this.register(new ManagedBool("rs_powered", false, DataFlags.SAVE_NBT_SYNC_TILE, DataFlags.TRIGGER_UPDATE)) : null;
    private String customName = "";
    private Set<PlayerEntity> accessingPlayers = new HashSet<PlayerEntity>();
    private int tick = 0;

    public TileBCore(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public TileDataManager getDataManager() {
        return this.dataManager;
    }

    public TileCapabilityManager getCapManager() {
        return this.capManager;
    }

    public <M extends IManagedData> M register(M managedData) {
        return this.dataManager.register(managedData);
    }

    public void tick() {
        this.tickables.forEach(Runnable::run);
        this.detectAndSendChanges();
        ++this.tick;
    }

    public void detectAndSendChanges() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.dataManager.detectAndSendChanges();
            this.capManager.detectAndSendChanges();
        }
    }

    public void detectAndSendChangesToListeners(List<IContainerListener> listeners) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.dataManager.detectAndSendChangesToListeners(listeners);
            this.capManager.detectAndSendChangesToListeners(listeners);
        }
    }

    public int getAccessDistanceSq() {
        return 64;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compound = new CompoundNBT();
        this.dataManager.writeSyncNBT(compound);
        this.writeExtraNBT(compound);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, compound);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = super.func_189517_E_();
        this.dataManager.writeSyncNBT(compound);
        this.writeExtraNBT(compound);
        return compound;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.dataManager.readSyncNBT(tag);
        this.readExtraNBT(tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.dataManager.readSyncNBT(pkt.func_148857_g());
        this.readExtraNBT(pkt.func_148857_g());
    }

    public PacketCustom createServerBoundPacket(int id) {
        Container container;
        PlayerEntity player = BrandonsCore.proxy.getClientPlayer();
        if (player != null && (container = player.field_71070_bA) instanceof ContainerBCTile && ((ContainerBCTile)container).tile == this) {
            PacketCustom packet = ((ContainerBCTile)container).createServerBoundPacket(1);
            packet.writeByte((int)((byte)id));
            return packet;
        }
        return new PacketCustom(BCoreNetwork.CHANNEL, 99);
    }

    public void sendPacketToServer(Consumer<MCDataOutput> writer, int id) {
        PacketCustom packet = this.createServerBoundPacket(id);
        writer.accept((MCDataOutput)packet);
        packet.sendToServer();
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayerEntity client, int id) {
        if (this.serverPacketHandlers.containsKey(id)) {
            this.serverPacketHandlers.get(id).accept(data, client);
        }
    }

    public PacketCustom createClientBoundPacket(int id) {
        PacketCustom packet = new PacketCustom(BCoreNetwork.CHANNEL, 2);
        packet.writePos(this.field_174879_c);
        packet.writeByte((int)((byte)id));
        return packet;
    }

    public PacketCustom sendPacketToClient(Consumer<MCDataOutput> writer, int id) {
        PacketCustom packet = this.createClientBoundPacket(id);
        writer.accept((MCDataOutput)packet);
        return packet;
    }

    public void sendPacketToClient(ServerPlayerEntity player, Consumer<MCDataOutput> writer, int id) {
        this.sendPacketToClient(writer, id).sendToPlayer(player);
    }

    public void sendPacketToClients(Collection<PlayerEntity> players, Consumer<MCDataOutput> writer, int id) {
        PacketCustom packet = this.createClientBoundPacket(id);
        writer.accept((MCDataOutput)packet);
        this.sendPacketToClients(players, packet);
    }

    public void sendPacketToClients(Collection<PlayerEntity> players, PacketCustom packet) {
        players.stream().filter(e -> e instanceof ServerPlayerEntity).map(e -> (ServerPlayerEntity)e).forEach(arg_0 -> ((PacketCustom)packet).sendToPlayer(arg_0));
    }

    public void sendPacketToChunk(Consumer<MCDataOutput> writer, int id) {
        this.sendPacketToClient(writer, id).sendToChunk((TileEntity)this);
    }

    public void receivePacketFromServer(MCDataInput data, int id) {
        if (this.clientPacketHandlers.containsKey(id)) {
            this.clientPacketHandlers.get(id).accept(data);
        }
    }

    public void setClientSidePacketHandler(int packetId, Consumer<MCDataInput> handler) {
        this.clientPacketHandlers.put(packetId, handler);
    }

    public void setServerSidePacketHandler(int packetId, BiConsumer<MCDataInput, ServerPlayerEntity> handler) {
        this.serverPacketHandlers.put(packetId, handler);
    }

    public void updateBlock() {
        BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public void dirtyBlock() {
        Chunk chunk = this.field_145850_b.func_175726_f(this.func_174877_v());
        chunk.func_177427_f(true);
    }

    public <T extends Runnable> T addTickable(T runnable) {
        this.tickables.add(runnable);
        return runnable;
    }

    public boolean removeTickable(Runnable runnable) {
        return this.tickables.remove(runnable);
    }

    @Override
    public void writeToItemStack(CompoundNBT compound, boolean willHarvest) {
        this.dataManager.writeToStackNBT(compound);
        this.savedItemDataObjects.forEach((tagName, serializable) -> compound.func_218657_a(tagName, serializable.serializeNBT()));
        CompoundNBT capTags = this.capManager.serialize(true);
        if (!capTags.isEmpty()) {
            compound.func_218657_a("bc_caps", (INBT)capTags);
        }
        this.writeExtraTileAndStack(compound);
    }

    @Override
    public void readFromItemStack(CompoundNBT compound) {
        this.dataManager.readFromStackNBT(compound);
        this.savedItemDataObjects.forEach((tagName, serializable) -> serializable.deserializeNBT((INBT)compound.func_74775_l(tagName)));
        if (compound.func_74764_b("bc_caps")) {
            this.capManager.deserialize(compound.func_74775_l("bc_caps"));
        }
        this.readExtraTileAndStack(compound);
    }

    public void writeExtraNBT(CompoundNBT compound) {
        CompoundNBT capTags = this.capManager.serialize(false);
        if (!capTags.isEmpty()) {
            compound.func_218657_a("bc_caps", (INBT)capTags);
        }
        if (!this.customName.isEmpty()) {
            compound.func_74778_a("custom_name", this.customName);
        }
        this.savedDataObjects.forEach((tagName, serializable) -> compound.func_218657_a(tagName, serializable.serializeNBT()));
        this.writeExtraTileAndStack(compound);
    }

    public void readExtraNBT(CompoundNBT compound) {
        if (compound.func_74764_b("bc_caps")) {
            this.capManager.deserialize(compound.func_74775_l("bc_caps"));
        }
        if (compound.func_150297_b("custom_name", 8)) {
            this.customName = compound.func_74779_i("custom_name");
        }
        this.savedDataObjects.forEach((tagName, serializable) -> serializable.deserializeNBT((INBT)compound.func_74775_l(tagName)));
        this.readExtraTileAndStack(compound);
    }

    public void writeExtraTileAndStack(CompoundNBT compound) {
    }

    public void readExtraTileAndStack(CompoundNBT compound) {
    }

    public final CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.dataManager.writeToNBT(compound);
        this.writeExtraNBT(compound);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.dataManager.readFromNBT(nbt);
        this.readExtraNBT(nbt);
        this.onTileLoaded();
    }

    public void onTileLoaded() {
    }

    public void setSavedDataObject(String tagName, INBTSerializable<CompoundNBT> dataObject) {
        this.savedDataObjects.put(tagName, dataObject);
    }

    public void setItemSavedDataObject(String tagName, INBTSerializable<CompoundNBT> dataObject) {
        this.savedItemDataObjects.put(tagName, dataObject);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        LazyOptional ret = this.capManager.getCapability(capability, side);
        return ret.isPresent() ? ret : super.getCapability(capability, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.capManager.invalidate();
    }

    public long sendEnergyToAll(long maxPerTarget, long maxAvailable) {
        long i = 0L;
        for (Direction direction : Direction.values()) {
            i += this.sendEnergyTo(Math.min(maxPerTarget, maxAvailable - i), direction);
        }
        return i;
    }

    public long sendEnergyTo(long maxSend, Direction side) {
        if (maxSend == 0L) {
            return 0L;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        if (tile != null) {
            return EnergyUtils.insertEnergy(tile, maxSend, side.func_176734_d(), false);
        }
        return 0L;
    }

    public static long sendEnergyTo(IWorldReader world, BlockPos pos, long maxSend, Direction side) {
        if (maxSend == 0L) {
            return 0L;
        }
        TileEntity tile = world.func_175625_s(pos.func_177972_a(side));
        if (tile != null) {
            return EnergyUtils.insertEnergy(tile, maxSend, side.func_176734_d(), false);
        }
        return 0L;
    }

    public static long sendEnergyToAll(IWorldReader world, BlockPos pos, long maxPerTarget, long maxAvailable) {
        long i = 0L;
        for (Direction direction : Direction.values()) {
            i += TileBCore.sendEnergyTo(world, pos, Math.min(maxPerTarget, maxAvailable - i), direction);
        }
        return i;
    }

    public void installIOTracker(OPStorage storage) {
        storage.setIOTracker(this.addTickable(new IOTracker()));
    }

    public void setupPowerSlot(IItemHandler itemHandler, int slot, IOPStorage storage, ManagedBool chargeItem) {
        this.setupPowerSlot(itemHandler, slot, storage, chargeItem::get);
    }

    public void setupPowerSlot(IItemHandler itemHandler, int slot, IOPStorage storage, boolean chargeItem) {
        this.setupPowerSlot(itemHandler, slot, storage, () -> chargeItem);
    }

    private void setupPowerSlot(IItemHandler itemHandler, int slot, IOPStorage storage, Supplier<Boolean> chargeItem) {
        if (itemHandler instanceof TileItemStackHandler) {
            ((TileItemStackHandler)itemHandler).setSlotValidator(slot, stack -> (Boolean)chargeItem.get() != false ? EnergyUtils.canReceiveEnergy(stack) : EnergyUtils.canExtractEnergy(stack));
        }
        if (EffectiveSide.get().isServer()) {
            this.addTickable(() -> {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                if (!stack.func_190926_b()) {
                    if (((Boolean)chargeItem.get()).booleanValue()) {
                        EnergyUtils.transferEnergy(storage, stack);
                    } else {
                        EnergyUtils.transferEnergy(stack, storage);
                    }
                }
            });
        }
    }

    public int getTime() {
        return this.tick;
    }

    public boolean onInterval(int tickInterval) {
        return this.tick % tickInterval == 0;
    }

    public IRSSwitchable.RSMode getRSMode() {
        if (!(this instanceof IRSSwitchable)) {
            throw new IllegalStateException("Tile does not implement IRSSwitchable");
        }
        return this.rsControlMode.get();
    }

    public void setRSMode(IRSSwitchable.RSMode mode) {
        if (!(this instanceof IRSSwitchable)) {
            throw new IllegalStateException("Tile does not implement IRSSwitchable");
        }
        this.rsControlMode.set(mode);
    }

    public void cycleRSMode(boolean reverse) {
        this.rsControlMode.set(this.rsControlMode.get().next(reverse));
    }

    public void onNeighborChange(BlockPos neighbor) {
        if (this instanceof IRSSwitchable) {
            boolean lastSignal = this.rsPowered.get();
            this.rsPowered.set(this.field_145850_b.func_175640_z(this.field_174879_c));
            if (this.rsPowered.get() != lastSignal) {
                this.onSignalChange(this.rsPowered.get());
            }
        }
    }

    public void onSignalChange(boolean newSignal) {
    }

    public boolean isTileEnabled() {
        if (this instanceof IRSSwitchable) {
            return this.rsControlMode.get().canRun(this.rsPowered.get());
        }
        return true;
    }

    public boolean hasRSSignal() {
        return this.field_145850_b.func_175640_z(this.func_174877_v());
    }

    public int getRSSignal() {
        return this.field_145850_b.func_175687_A(this.func_174877_v());
    }

    public ITextComponent func_200200_C_() {
        if (this.func_145818_k_()) {
            return new StringTextComponent(this.customName);
        }
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    public boolean func_145818_k_() {
        return !this.customName.isEmpty();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName.isEmpty() ? null : this.func_200200_C_();
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public void enablePlayerAccessTracking(boolean playerAccessTracking) {
        this.playerAccessTracking = playerAccessTracking;
    }

    public Set<PlayerEntity> getAccessingPlayers() {
        this.accessingPlayers.removeIf(e -> !(e.field_71070_bA instanceof ContainerBCore) || ((ContainerBCTile)e.field_71070_bA).tile != this);
        return this.accessingPlayers;
    }

    public void onPlayerOpenContainer(PlayerEntity player) {
        this.accessingPlayers.add(player);
    }

    public void onPlayerCloseContainer(PlayerEntity player) {
        this.accessingPlayers.remove(player);
        this.accessingPlayers.removeIf(e -> !(e.field_71070_bA instanceof ContainerBCore) || ((ContainerBCTile)e.field_71070_bA).tile != this);
    }
}

