/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiOpenEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;

public class CursorHelper {
    public static final ResourceLocation DRAG = new ResourceLocation("brandonscore", "textures/gui/cursors/drag.png");
    public static final ResourceLocation RESIZE_H = new ResourceLocation("brandonscore", "textures/gui/cursors/resize_h.png");
    public static final ResourceLocation RESIZE_V = new ResourceLocation("brandonscore", "textures/gui/cursors/resize_v.png");
    public static final ResourceLocation RESIZE_TRBL = new ResourceLocation("brandonscore", "textures/gui/cursors/resize_diag_trbl.png");
    public static final ResourceLocation RESIZE_TLBR = new ResourceLocation("brandonscore", "textures/gui/cursors/resize_diag_tlbr.png");
    private static Map<ResourceLocation, Long> cursors = new HashMap<ResourceLocation, Long>();
    private static ResourceLocation active = null;

    private static long createCursor(ResourceLocation resource) {
        try {
            BufferedImage bufferedimage = ImageIO.read(Minecraft.func_71410_x().func_195551_G().func_199002_a(resource).func_199027_b());
            GLFWImage glfwImage = CursorHelper.imageToGLFWImage(bufferedimage);
            return GLFW.glfwCreateCursor((GLFWImage)glfwImage, (int)16, (int)16);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static GLFWImage imageToGLFWImage(BufferedImage image) {
        if (image.getType() != 3) {
            BufferedImage convertedImage = new BufferedImage(image.getWidth(), image.getHeight(), 3);
            Graphics2D graphics = convertedImage.createGraphics();
            int targetWidth = image.getWidth();
            int targetHeight = image.getHeight();
            graphics.drawImage(image, 0, 0, targetWidth, targetHeight, null);
            graphics.dispose();
            image = convertedImage;
        }
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(image.getWidth() * image.getHeight() * 4));
        for (int i = 0; i < image.getHeight(); ++i) {
            for (int j = 0; j < image.getWidth(); ++j) {
                int colorSpace = image.getRGB(j, i);
                buffer.put((byte)(colorSpace << 8 >> 24));
                buffer.put((byte)(colorSpace << 16 >> 24));
                buffer.put((byte)(colorSpace << 24 >> 24));
                buffer.put((byte)(colorSpace >> 24));
            }
        }
        buffer.flip();
        GLFWImage result = GLFWImage.create();
        result.set(image.getWidth(), image.getHeight(), buffer);
        return result;
    }

    public static void closeGui(GuiOpenEvent event) {
        if (event.getGui() == null) {
            CursorHelper.resetCursor();
        }
    }

    public static void setCursor(@Nullable ResourceLocation cursor) {
        if (cursor != active) {
            active = cursor;
            long window = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
            long newCursor = active == null ? 0L : cursors.computeIfAbsent(cursor, CursorHelper::createCursor);
            try {
                GLFW.glfwSetCursor((long)window, (long)newCursor);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void resetCursor() {
        if (active != null) {
            CursorHelper.setCursor(null);
        }
    }
}

