/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.effects;

import com.brandon3055.brandonscore.client.gui.effects.GuiEffect;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GuiEffectRenderer {
    private List<GuiEffect> effects = new ArrayList<GuiEffect>();

    public void updateEffects() {
        Iterator<GuiEffect> i = this.effects.iterator();
        while (i.hasNext()) {
            GuiEffect effect = i.next();
            if (effect.isAlive()) {
                effect.onUpdate();
                continue;
            }
            i.remove();
        }
    }

    public void renderEffects(float partialTick) {
        for (GuiEffect effect : this.effects) {
            if (effect.isTransparent()) {
                RenderSystem.enableBlend();
                RenderSystem.alphaFunc((int)516, (float)0.0f);
            }
            RenderSystem.disableLighting();
            effect.renderParticle(partialTick);
            if (!effect.isTransparent()) continue;
            RenderSystem.alphaFunc((int)516, (float)0.1f);
        }
    }

    public void addEffect(GuiEffect effect) {
        this.effects.add(effect);
    }

    public void clearEffects() {
        this.effects.clear();
    }

    public List<GuiEffect> getActiveEffects() {
        return this.effects;
    }
}

