/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.render.GuiHelper;
import com.brandon3055.brandonscore.client.BCSprites;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.RenderMaterial;

public class GuiProgressIcon
extends GuiElement<GuiProgressIcon> {
    private RenderMaterial baseTexture;
    private RenderMaterial overlayTexture;
    private Supplier<RenderMaterial> baseTextureSupplier;
    private Supplier<RenderMaterial> overlayTextureSupplier;
    private Direction direction;
    private Supplier<Double> progressSupplier = () -> 0.0;
    private int upperMargin = 0;
    private int lowerMargin = 0;

    public GuiProgressIcon(RenderMaterial baseTexture, RenderMaterial overlayTexture, Direction animDirection) {
        this.baseTexture = baseTexture;
        this.overlayTexture = overlayTexture;
        this.direction = animDirection;
    }

    public GuiProgressIcon(Supplier<RenderMaterial> baseTexture, Supplier<RenderMaterial> overlayTexture, Direction animDirection) {
        this.baseTextureSupplier = baseTexture;
        this.overlayTextureSupplier = overlayTexture;
        this.direction = animDirection;
    }

    public GuiProgressIcon setProgressSupplier(Supplier<Double> progressSupplier) {
        this.progressSupplier = progressSupplier;
        return this;
    }

    public GuiProgressIcon setProgress(double progress) {
        this.progressSupplier = () -> progress;
        return this;
    }

    public GuiProgressIcon setMargins(int lowerMargin, int upperMargin) {
        this.upperMargin = upperMargin;
        this.lowerMargin = lowerMargin;
        return this;
    }

    public double getProgress() {
        return this.progressSupplier.get();
    }

    /*
     * Unable to fully structure code
     */
    private double getRenderState() {
        progress = this.getProgress();
        if (this.direction == Direction.LEFT) ** GOTO lbl-1000
        if (this.direction == Direction.RIGHT) lbl-1000:
        // 2 sources

        {
            v0 = this.xSize();
        } else {
            v0 = this.ySize();
        }
        axis = v0;
        size = axis - (double)this.upperMargin - (double)this.lowerMargin;
        return MathHelper.clip((double)(((double)this.lowerMargin + Math.ceil(size * progress)) / axis), (double)0.0, (double)1.0);
    }

    private RenderMaterial getOverlay() {
        return this.overlayTextureSupplier == null ? this.overlayTexture : this.overlayTextureSupplier.get();
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        RenderMaterial base = this.baseTextureSupplier == null ? this.baseTexture : this.baseTextureSupplier.get();
        this.drawSprite(getter.getBuffer(base.func_229312_a_(BCSprites::makeType)), this.xPos(), this.yPos(), this.xSize(), this.ySize(), base.func_229314_c_());
        this.direction.draw(this, getter);
        getter.func_228461_a_();
    }

    public static enum Direction {
        UP((icon, getter) -> GuiHelper.drawPartialSprite(getter.getBuffer(((GuiProgressIcon)icon).getOverlay().func_229312_a_(BCSprites::makeType)), icon.xPos(), (double)icon.yPos() + (double)icon.ySize() * (1.0 - ((GuiProgressIcon)icon).getRenderState()), icon.xSize(), (double)icon.ySize() * ((GuiProgressIcon)icon).getRenderState(), ((GuiProgressIcon)icon).getOverlay().func_229314_c_(), 0.0, 1.0 - ((GuiProgressIcon)icon).getRenderState(), 1.0, 1.0)),
        DOWN((icon, getter) -> GuiHelper.drawPartialSprite(getter.getBuffer(((GuiProgressIcon)icon).getOverlay().func_229312_a_(BCSprites::makeType)), icon.xPos(), icon.yPos(), icon.xSize(), (double)icon.ySize() * ((GuiProgressIcon)icon).getRenderState(), ((GuiProgressIcon)icon).getOverlay().func_229314_c_(), 0.0, 0.0, 1.0, ((GuiProgressIcon)icon).getRenderState())),
        LEFT((icon, getter) -> GuiHelper.drawPartialSprite(getter.getBuffer(((GuiProgressIcon)icon).getOverlay().func_229312_a_(BCSprites::makeType)), (double)icon.xPos() + (double)icon.xSize() * (1.0 - ((GuiProgressIcon)icon).getRenderState()), icon.yPos(), (double)icon.xSize() * ((GuiProgressIcon)icon).getRenderState(), icon.ySize(), ((GuiProgressIcon)icon).getOverlay().func_229314_c_(), 1.0 - ((GuiProgressIcon)icon).getRenderState(), 0.0, 1.0, 1.0)),
        RIGHT((icon, getter) -> GuiHelper.drawPartialSprite(getter.getBuffer(((GuiProgressIcon)icon).getOverlay().func_229312_a_(BCSprites::makeType)), icon.xPos(), icon.yPos(), (double)icon.xSize() * ((GuiProgressIcon)icon).getRenderState(), icon.ySize(), ((GuiProgressIcon)icon).getOverlay().func_229314_c_(), 0.0, 0.0, ((GuiProgressIcon)icon).getRenderState(), 1.0));

        private BiConsumer<GuiProgressIcon, IRenderTypeBuffer.Impl> drawFunc;

        private Direction(BiConsumer<GuiProgressIcon, IRenderTypeBuffer.Impl> drawFunc) {
            this.drawFunc = drawFunc;
        }

        private void draw(GuiProgressIcon icon, IRenderTypeBuffer.Impl getter) {
            this.drawFunc.accept(icon, getter);
        }
    }
}

