/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IGuiEventListener;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class GuiTexturedPointer
extends GuiElement<GuiTexturedPointer> {
    private int texPosX;
    private int texPosY;
    private int sliderWitdh;
    private ResourceLocation texture;
    public IGuiEventListener listener;
    public double position = 0.0;
    public boolean horizontal = false;
    public int barColour = -16777216;
    public int sliderColour = -1;

    protected GuiTexturedPointer() {
    }

    protected GuiTexturedPointer(int xPos, int yPos) {
        super(xPos, yPos);
    }

    public GuiTexturedPointer(int xPos, int yPos, int xSize, int ySize, int texPosX, int texPosY, int sliderWidth, ResourceLocation texture) {
        super(xPos, yPos, xSize, ySize);
        this.texPosX = texPosX;
        this.texPosY = texPosY;
        this.sliderWitdh = sliderWidth;
        this.texture = texture;
    }

    @Override
    public void addChildElements() {
        super.addChildElements();
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        if (this.texture != null) {
            this.bindTexture(this.texture);
        }
        if (this.horizontal) {
            double offset = (1.0 - this.getPos()) * (double)(this.xSize() - this.sliderWitdh);
            this.drawTexturedModalRect((double)this.xPos() + offset, (double)this.yPos(), this.texPosX, this.texPosY, this.sliderWitdh, this.ySize());
        } else {
            double offset = (1.0 - this.getPos()) * (double)(this.ySize() - this.sliderWitdh);
            this.drawTexturedModalRect((double)this.xPos(), (double)this.yPos() + offset, this.texPosX, this.texPosY, this.xSize(), this.sliderWitdh);
        }
    }

    public GuiTexturedPointer setColours(int barColour, int sliderColour) {
        this.barColour = barColour;
        this.sliderColour = sliderColour;
        return this;
    }

    public GuiTexturedPointer setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
        return this;
    }

    public double getPos() {
        return this.position;
    }

    public void setPos(double pos) {
        if (pos > 1.0) {
            pos = 1.0;
        } else if (pos < 0.0) {
            pos = 0.0;
        }
        this.position = pos;
    }
}

