/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;

public class TileItemStackHandler
extends ItemStackHandler {
    private BiPredicate<Integer, ItemStack> stackValidator = null;
    private Runnable loadListener = null;
    private Consumer<Integer> contentsChangeListener = null;
    private Map<Integer, Predicate<ItemStack>> slotValidators = new HashMap<Integer, Predicate<ItemStack>>();
    private ItemStack prevStack = ItemStack.field_190927_a;
    private Supplier<Integer> perSlotLimit = null;
    private int slotLimit = 64;

    public TileItemStackHandler() {
    }

    public TileItemStackHandler(int size) {
        super(size);
    }

    public TileItemStackHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    public TileItemStackHandler setStackValidator(BiPredicate<Integer, ItemStack> stackValidator) {
        this.stackValidator = stackValidator;
        return this;
    }

    public TileItemStackHandler setStackValidator(Predicate<ItemStack> stackValidator) {
        this.stackValidator = (integer, stack) -> stackValidator.test((ItemStack)stack);
        return this;
    }

    public TileItemStackHandler setSlotValidator(int slot, Predicate<ItemStack> validator) {
        this.slotValidators.put(slot, validator);
        return this;
    }

    public TileItemStackHandler setLoadListener(Runnable loadListener) {
        this.loadListener = loadListener;
        return this;
    }

    public TileItemStackHandler setContentsChangeListener(Consumer<Integer> contentsChangeListener) {
        this.contentsChangeListener = contentsChangeListener;
        return this;
    }

    public TileItemStackHandler setPerSlotLimit(Supplier<Integer> perSlotLimit) {
        this.perSlotLimit = perSlotLimit;
        return this;
    }

    public TileItemStackHandler setSlotLimit(int slotLimit) {
        this.slotLimit = slotLimit;
        return this;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        this.prevStack = this.getStackInSlot(slot);
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.prevStack = this.getStackInSlot(slot);
        return super.extractItem(slot, amount, simulate);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (this.slotValidators.containsKey(slot)) {
            return this.slotValidators.get(slot).test(stack);
        }
        return this.stackValidator == null || this.stackValidator.test(slot, stack);
    }

    public CompoundNBT serializeNBT() {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((ItemStack)this.stacks.get(i)).func_190926_b()) continue;
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_74768_a("Slot", i);
            ((ItemStack)this.stacks.get(i)).func_77955_b(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Items", (INBT)nbtTagList);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.stacks.clear();
        ListNBT tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)itemTags));
        }
        this.onLoad();
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.contentsChangeListener != null) {
            this.contentsChangeListener.accept(slot);
        }
    }

    protected void onLoad() {
        super.onLoad();
        if (this.loadListener != null) {
            this.loadListener.run();
        }
    }

    public ItemStack getListenerPrevStack() {
        return this.prevStack;
    }

    public int getSlotLimit(int slot) {
        return this.perSlotLimit == null ? this.slotLimit : this.perSlotLimit.get();
    }
}

