/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StringyStacks {
    public static final Logger LOGGER = LogManager.getLogger((String)"StackConverter");

    public static ItemStack fromString(String stackString) {
        return StringyStacks.fromString(stackString, ItemStack.field_190927_a);
    }

    public static ItemStack fromString(String stackString, @Nullable ItemStack defaultIfInputInvalid) {
        ItemStack stack;
        if (stackString.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (!stackString.contains(":")) {
            LOGGER.warn("StackReference: Was given an invalid stack string. String did not contain \":\" - " + stackString);
            return defaultIfInputInvalid;
        }
        if (stackString.contains("{") && stackString.contains(",") && stackString.indexOf(",") < stackString.indexOf("{")) {
            try {
                return StringyStacks.legacyFromString(stackString, defaultIfInputInvalid);
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to parse legacy stack string - " + stackString + " error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        String stackStr = stackString;
        String itemID = stackStr.contains("{") ? stackStr.substring(0, stackStr.indexOf("{")) : (stackStr.contains(",") ? stackStr.substring(0, stackStr.indexOf(",")) : stackStr);
        stackStr = stackString.substring(itemID.length());
        CompoundNBT tagNBT = null;
        if (stackStr.startsWith("{")) {
            if (!stackString.contains("}") || stackStr.lastIndexOf("}") < stackString.indexOf("{")) {
                LOGGER.warn("Detected invalid NBT definition on stack string - " + stackString);
                return defaultIfInputInvalid;
            }
            String tag = stackStr.substring(0, stackStr.lastIndexOf("}") + 1);
            try {
                tagNBT = JsonToNBT.func_180713_a((String)tag);
            }
            catch (Throwable e) {
                LOGGER.warn("Failed to parse stack nbt from string - " + tag + ", on stack string - " + stackString + ". error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
            stackStr = stackString.substring(tag.length());
        }
        int count = 1;
        if (stackStr.startsWith(",") && stackString.length() > 1) {
            try {
                count = Integer.parseInt(stackStr.substring(1));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse stack size from string - " + stackStr + ", on stack string - " + stackString + ". error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        CompoundNBT stackNBT = new CompoundNBT();
        stackNBT.func_74778_a("id", itemID);
        stackNBT.func_74774_a("Count", (byte)count);
        if (tagNBT != null && !tagNBT.isEmpty()) {
            if (tagNBT.func_186856_d() == 2 && tagNBT.func_150297_b("tag", 10) && tagNBT.func_74764_b("ForgeCaps")) {
                CompoundNBT caps;
                CompoundNBT tag = tagNBT.func_74775_l("tag");
                if (!tag.isEmpty()) {
                    stackNBT.func_218657_a("tag", (INBT)tag);
                }
                if (!(caps = tagNBT.func_74775_l("ForgeCaps")).isEmpty()) {
                    stackNBT.func_218657_a("ForgeCaps", (INBT)caps);
                }
            } else {
                stackNBT.func_218657_a("tag", (INBT)tagNBT);
            }
        }
        if ((stack = ItemStack.func_199557_a((CompoundNBT)stackNBT)) == ItemStack.field_190927_a) {
            return defaultIfInputInvalid;
        }
        return stack;
    }

    private static ItemStack legacyFromString(String string, @Nullable ItemStack defaultIfInputInvalid) {
        String stackString;
        String workString = string;
        String splitter = ",";
        String countString = "";
        String metaString = "";
        String nbt = "";
        if (!workString.contains(splitter)) {
            stackString = workString;
            workString = "";
        } else {
            stackString = workString.substring(0, workString.indexOf(splitter));
            workString = workString.substring(workString.indexOf(splitter) + splitter.length());
        }
        if (workString.length() > 0) {
            if (!workString.contains(splitter)) {
                countString = workString;
                workString = "";
            } else {
                countString = workString.substring(0, workString.indexOf(splitter));
                workString = workString.substring(workString.indexOf(splitter) + splitter.length());
            }
        }
        if (workString.length() > 0) {
            if (!workString.contains(splitter)) {
                metaString = workString;
                workString = "";
            } else {
                metaString = workString.substring(0, workString.indexOf(splitter));
                workString = workString.substring(workString.indexOf(splitter) + splitter.length());
            }
        }
        if (workString.length() > 0) {
            nbt = workString;
        }
        int count = 1;
        int meta = 0;
        CompoundNBT compound = null;
        if (countString.length() > 0) {
            try {
                count = Integer.parseInt(countString);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse stack size from string - " + countString + " error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        if (metaString.length() > 0) {
            try {
                meta = Integer.parseInt(metaString);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse stack meta from string - " + metaString + " error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        if (nbt.length() > 0) {
            try {
                compound = JsonToNBT.func_180713_a((String)nbt);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse stack nbt from string - " + nbt + " error: " + e.getMessage());
                return defaultIfInputInvalid;
            }
        }
        ResourceLocation registryName = new ResourceLocation(stackString);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(registryName);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(registryName);
        if (item == null && block == Blocks.field_150350_a) {
            return defaultIfInputInvalid;
        }
        ItemStack itemStack = item != null ? new ItemStack((IItemProvider)item, count) : new ItemStack((IItemProvider)block, count);
        itemStack.func_196085_b(meta);
        if (compound != null) {
            itemStack.func_77982_d(compound);
        }
        return itemStack;
    }

    public static String toString(ItemStack stack, boolean withNBT, boolean withCount, boolean withForgeCaps) {
        if (stack.func_190926_b()) {
            return "";
        }
        String stackString = stack.func_77973_b().getRegistryName().toString();
        if (withNBT || withForgeCaps) {
            CompoundNBT stackTag = stack.serializeNBT();
            CompoundNBT nbt = null;
            CompoundNBT caps = null;
            if (withNBT && stackTag.func_150297_b("tag", 10)) {
                nbt = stackTag.func_74775_l("tag");
            }
            if (withForgeCaps && stackTag.func_74764_b("ForgeCaps")) {
                caps = stackTag.func_74775_l("ForgeCaps");
            }
            CompoundNBT stringTag = null;
            if (nbt != null && caps == null) {
                stringTag = nbt;
            } else if (caps != null) {
                stringTag = new CompoundNBT();
                stringTag.func_218657_a("ForgeCaps", (INBT)caps);
                stringTag.func_218657_a("tag", (INBT)(nbt == null ? new CompoundNBT() : nbt));
            }
            if (stringTag != null && !stringTag.isEmpty()) {
                stackString = stackString + stringTag.toString();
            }
        }
        if (withCount && stack.func_190916_E() > 1) {
            stackString = stackString + "," + stack.func_190916_E();
        }
        return stackString;
    }

    public static String toStringNoCaps(ItemStack stack) {
        return StringyStacks.toString(stack, true, true, false);
    }

    public static String toString(ItemStack stack) {
        return StringyStacks.toString(stack, true, true, true);
    }

    @Deprecated
    public static ItemStack legacyStackConverter(String itemString, int count, int damage, @Nullable CompoundNBT nbt) {
        try {
            ResourceLocation itemID = new ResourceLocation(itemString);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemID);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(itemID);
            if (item == null && block == Blocks.field_150350_a) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemStack = item != null ? new ItemStack((IItemProvider)item, count) : new ItemStack((IItemProvider)block, count);
            itemStack.func_196085_b(damage);
            if (nbt != null) {
                itemStack.func_77982_d(nbt.func_74737_b());
            }
            return itemStack;
        }
        catch (Throwable e) {
            return ItemStack.field_190927_a;
        }
    }
}

