/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class TeleportUtils {
    public static Entity teleportEntity(Entity entity, Entity destination) {
        return TeleportUtils.teleportEntity(entity, (RegistryKey<World>)destination.field_70170_p.func_234923_W_(), destination.func_226277_ct_(), destination.func_226278_cu_(), destination.field_70136_U, destination.field_70177_z, destination.field_70125_A);
    }

    public static Entity teleportEntity(Entity entity, RegistryKey<World> dimension, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return entity;
        }
        MinecraftServer server = entity.func_184102_h();
        RegistryKey sourceDim = entity.field_70170_p.func_234923_W_();
        if (!entity.func_184207_aI() && !entity.func_184218_aH()) {
            return TeleportUtils.handleEntityTeleport(entity, server, (RegistryKey<World>)sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        }
        Entity rootEntity = entity.func_184208_bv();
        PassengerHelper passengerHelper = new PassengerHelper(rootEntity);
        PassengerHelper rider = passengerHelper.getPassenger(entity);
        if (rider == null) {
            LogHelperBC.error("RiddenEntity: This error should not be possible");
            return entity;
        }
        passengerHelper.teleport(server, (RegistryKey<World>)sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        passengerHelper.remountRiders();
        passengerHelper.updateClients();
        return rider.entity;
    }

    public static Entity teleportEntity(Entity entity, RegistryKey<World> dimension, Vector3 pos, float yaw, float pitch) {
        return TeleportUtils.teleportEntity(entity, dimension, pos.x, pos.y, pos.z, yaw, pitch);
    }

    public static Entity teleportEntity(Entity entity, RegistryKey<World> dimension, double xCoord, double yCoord, double zCoord) {
        return TeleportUtils.teleportEntity(entity, dimension, xCoord, yCoord, zCoord, entity.field_70177_z, entity.field_70125_A);
    }

    public static Entity teleportEntity(Entity entity, RegistryKey<World> dimension, Vector3 pos) {
        return TeleportUtils.teleportEntity(entity, dimension, pos.x, pos.y, pos.z, entity.field_70177_z, entity.field_70125_A);
    }

    private static Entity handleEntityTeleport(Entity entity, MinecraftServer server, RegistryKey<World> sourceDim, RegistryKey<World> targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        boolean interDimensional;
        if (entity == null || entity.field_70170_p.field_72995_K || targetDim == null) {
            return entity;
        }
        boolean bl = interDimensional = sourceDim != targetDim;
        if (interDimensional && !ForgeHooks.onTravelToDimension((Entity)entity, sourceDim)) {
            return entity;
        }
        if (interDimensional) {
            if (entity instanceof ServerPlayerEntity) {
                return TeleportUtils.teleportPlayerInterdimentional((ServerPlayerEntity)entity, server, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
            return TeleportUtils.teleportEntityInterdimentional(entity, server, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
        }
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
            player.func_70034_d(yaw);
        } else {
            entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            entity.func_70034_d(yaw);
        }
        return entity;
    }

    private static Entity teleportEntityInterdimentional(Entity entity, MinecraftServer server, RegistryKey<World> targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        ServerWorld targetWorld = server.func_71218_a(targetDim);
        if (!entity.func_70089_S() || targetWorld == null) {
            return null;
        }
        Entity movedEntity = entity.func_241206_a_(targetWorld);
        if (movedEntity != null) {
            movedEntity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            return movedEntity;
        }
        entity.func_213319_R();
        movedEntity = entity.func_200600_R().func_200721_a((World)targetWorld);
        if (movedEntity != null) {
            movedEntity.func_180432_n(entity);
            movedEntity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            targetWorld.func_217460_e(movedEntity);
            entity.remove(false);
            ((ServerWorld)entity.field_70170_p).func_82742_i();
            targetWorld.func_82742_i();
            return movedEntity;
        }
        return entity;
    }

    private static PlayerEntity teleportPlayerInterdimentional(ServerPlayerEntity player, MinecraftServer server, RegistryKey<World> targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        ServerWorld originWorld = player.func_71121_q();
        ServerWorld targetWorld = server.func_71218_a(targetDim);
        if (!player.func_70089_S() || targetWorld == null) {
            return player;
        }
        player.field_184851_cj = true;
        player.func_200619_a(targetWorld, xCoord, yCoord, zCoord, yaw, pitch);
        player.field_71144_ck = -1;
        player.field_71149_ch = -1.0f;
        player.field_71146_ci = -1;
        player.func_71016_p();
        return player;
    }

    public static Entity getHighestRidingEntity(Entity mount) {
        Entity entity = mount;
        while (entity.func_184188_bt().size() > 0) {
            entity = (Entity)entity.func_184188_bt().get(0);
        }
        return entity;
    }

    private static class PassengerHelper {
        public Entity entity;
        public LinkedList<PassengerHelper> passengers = new LinkedList();
        public double offsetX;
        public double offsetY;
        public double offsetZ;

        public PassengerHelper(Entity entity) {
            this.entity = entity;
            if (entity.func_184218_aH()) {
                this.offsetX = entity.func_226277_ct_() - entity.func_184187_bx().func_226277_ct_();
                this.offsetY = entity.func_226278_cu_() - entity.func_184187_bx().func_226278_cu_();
                this.offsetZ = entity.func_226281_cx_() - entity.func_184187_bx().func_226281_cx_();
            }
            for (Entity passenger : entity.func_184188_bt()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        public void teleport(MinecraftServer server, RegistryKey<World> sourceDim, RegistryKey<World> targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
            this.entity.func_184226_ay();
            this.entity = TeleportUtils.handleEntityTeleport(this.entity, server, (RegistryKey<World>)sourceDim, (RegistryKey<World>)targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            for (PassengerHelper passenger : this.passengers) {
                passenger.teleport(server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
        }

        public void remountRiders() {
            if (this.entity == null) {
                return;
            }
            if (this.entity.func_184218_aH()) {
                this.entity.func_70012_b(this.entity.func_226277_ct_() + this.offsetX, this.entity.func_226278_cu_() + this.offsetY, this.entity.func_226281_cx_() + this.offsetZ, this.entity.field_70177_z, this.entity.field_70125_A);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.entity.func_184205_a(this.entity, true);
                passenger.remountRiders();
            }
        }

        public void updateClients() {
            if (this.entity instanceof ServerPlayerEntity) {
                this.updateClient((ServerPlayerEntity)this.entity);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        private void updateClient(ServerPlayerEntity playerMP) {
            if (this.entity.func_184207_aI()) {
                playerMP.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket(this.entity));
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        public PassengerHelper getPassenger(Entity passenger) {
            if (this.entity == passenger) {
                return this;
            }
            for (PassengerHelper rider : this.passengers) {
                PassengerHelper re = rider.getPassenger(passenger);
                if (re == null) continue;
                return re;
            }
            return null;
        }
    }
}

