/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class ManagedNBT
extends AbstractManagedData<CompoundNBT> {
    private CompoundNBT value;
    private CompoundNBT lastValue;
    protected Function<CompoundNBT, CompoundNBT> validator = null;

    public ManagedNBT(String name, CompoundNBT defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        this.lastValue = defaultValue.func_74737_b();
    }

    public ManagedNBT(String name, DataFlags ... flags) {
        this(name, new CompoundNBT(), flags);
    }

    public CompoundNBT set(CompoundNBT value) {
        this.lastValue = value.func_74737_b();
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            CompoundNBT prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public CompoundNBT get() {
        return this.value;
    }

    public ManagedNBT setValidator(Function<CompoundNBT, CompoundNBT> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public boolean isDirty(boolean reset) {
        if (this.lastValue != null && !this.lastValue.equals((Object)this.value)) {
            if (reset) {
                this.lastValue = this.value.func_74737_b();
            }
            return true;
        }
        return super.isDirty(reset);
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeCompoundNBT(this.value);
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readCompoundNBT();
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundNBT compound) {
        compound.func_218657_a(this.name, (INBT)this.value);
    }

    @Override
    public void fromNBT(CompoundNBT compound) {
        this.value = compound.func_74775_l(this.name);
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }
}

