/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network;

import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.BCConfig;
import com.brandon3055.brandonscore.inventory.ContainerBCTile;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class ServerPacketHandler
implements ICustomPacketHandler.IServerPacketHandler {
    public void handlePacket(PacketCustom packet, ServerPlayerEntity sender, IServerPlayNetHandler handler) {
        switch (packet.getType()) {
            case 1: {
                this.handleContainerMessage(packet, sender, handler);
                break;
            }
            case 2: {
                this.handlePlayerAccess(packet, sender, handler);
                break;
            }
            case 3: {
                this.handleTileDataManager(packet, sender, handler);
            }
        }
    }

    private void handleContainerMessage(PacketCustom packet, ServerPlayerEntity sender, IServerPlayNetHandler handler) {
        try {
            if (sender.field_71070_bA instanceof ContainerBCTile) {
                ((ContainerBCTile)sender.field_71070_bA).handleContainerMessage(packet, sender);
            }
        }
        catch (Throwable e) {
            LogHelperBC.error("Something went wrong while attempting to read a packet sent from this client: " + sender);
            e.printStackTrace();
        }
    }

    private void handlePlayerAccess(PacketCustom packet, ServerPlayerEntity sender, IServerPlayNetHandler handler) {
    }

    private void handleTileDataManager(PacketCustom packet, ServerPlayerEntity sender, IServerPlayNetHandler handler) {
        try {
            if (sender.field_71070_bA instanceof ContainerBCTile) {
                ((ContainerBCTile)sender.field_71070_bA).handleTileDataPacket(packet, sender);
            }
        }
        catch (Throwable e) {
            LogHelperBC.error("Something went wrong while attempting to read data manager a packet sent from this client: " + sender);
            e.printStackTrace();
        }
    }

    @Deprecated
    public static boolean verifyPlayerPermission(PlayerEntity player, BlockPos pos) {
        if (!BCConfig.clientPermissionVerification) {
            return true;
        }
        BlockRayTraceResult traceResult = new BlockRayTraceResult(Vector3d.func_237489_a_((Vector3i)pos), Direction.UP, pos, false);
        PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(player, Hand.MAIN_HAND, pos, traceResult);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult() != Event.Result.DENY;
    }
}

