/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.StringUtils;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.data.element.ItemStackData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.Textures;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.mantle.client.screen.book.element.TooltipElement;

public class ContentSmelting
extends PageContent {
    private static final NonNullList<ItemStack> FUELS;
    public static final transient int TEX_SIZE = 128;
    public static final transient ImageData IMG_SMELTING;
    public static final transient int INPUT_X = 5;
    public static final transient int INPUT_Y = 5;
    public static final transient int RESULT_X = 74;
    public static final transient int RESULT_Y = 41;
    public static final transient int FUEL_X = 5;
    public static final transient int FUEL_Y = 77;
    public static final transient float ITEM_SCALE = 2.0f;
    public String title = "Smelting";
    public ItemStackData input;
    public ItemStackData result;
    public ItemStackData fuel;
    public int cookTime = 200;
    public TextData[] description;
    public String recipe;

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        int y;
        int x = BookScreen.PAGE_WIDTH / 2 - ContentSmelting.IMG_SMELTING.width / 2;
        if (this.title == null || this.title.isEmpty()) {
            y = 0;
        } else {
            this.addTitle(list, this.title);
            y = this.getTitleHeight();
        }
        list.add(new ImageElement(x, y, ContentSmelting.IMG_SMELTING.width, ContentSmelting.IMG_SMELTING.height, IMG_SMELTING, book.appearance.slotColor));
        list.add(new TooltipElement((List<ITextComponent>)ImmutableList.of((Object)new TranslationTextComponent("mantle:tooltip.cooktime", new Object[]{this.cookTime / 20})), x + 7, y + 42, 60, 28));
        if (this.input != null && !this.input.getItems().isEmpty()) {
            list.add(new ItemElement(x + 5, y + 5, 2.0f, (Collection<ItemStack>)this.input.getItems(), this.input.action));
        }
        if (this.result != null && !this.result.getItems().isEmpty()) {
            list.add(new ItemElement(x + 74, y + 41, 2.0f, (Collection<ItemStack>)this.result.getItems(), this.result.action));
        }
        list.add(new ItemElement(x + 5, y + 77, 2.0f, (Collection<ItemStack>)this.getFuelsList()));
        if (this.description != null && this.description.length > 0) {
            list.add(new TextElement(0, ContentSmelting.IMG_SMELTING.height + y + 5, BookScreen.PAGE_WIDTH, BookScreen.PAGE_HEIGHT - y - 5, this.description));
        }
    }

    public NonNullList<ItemStack> getFuelsList() {
        if (this.fuel != null) {
            return this.fuel.getItems();
        }
        return FUELS;
    }

    @Override
    public void load() {
        IRecipe recipe;
        super.load();
        if (!StringUtils.isEmpty((CharSequence)this.recipe) && ResourceLocation.func_217855_b((String)this.recipe) && (recipe = (IRecipe)Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215367_a(new ResourceLocation(this.recipe)).orElse(null)) instanceof AbstractCookingRecipe) {
            this.input = ItemStackData.getItemStackData((NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])((Ingredient)recipe.func_192400_c().get(0)).func_193365_a()));
            this.cookTime = ((AbstractCookingRecipe)recipe).func_222137_e();
            this.result = ItemStackData.getItemStackData(recipe.func_77571_b());
        }
    }

    static {
        IMG_SMELTING = new ImageData(Textures.TEX_SMELTING, 0, 0, 110, 114, 128, 128);
        FUELS = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196622_bq), new ItemStack((IItemProvider)Blocks.field_196624_br), new ItemStack((IItemProvider)Blocks.field_196627_bs), new ItemStack((IItemProvider)Blocks.field_196630_bt), new ItemStack((IItemProvider)Blocks.field_196632_bu), new ItemStack((IItemProvider)Blocks.field_196635_bv), new ItemStack((IItemProvider)Blocks.field_196662_n), new ItemStack((IItemProvider)Blocks.field_196664_o), new ItemStack((IItemProvider)Blocks.field_196666_p), new ItemStack((IItemProvider)Blocks.field_196668_q), new ItemStack((IItemProvider)Blocks.field_196670_r), new ItemStack((IItemProvider)Blocks.field_196672_s), new ItemStack((IItemProvider)Blocks.field_150402_ci), new ItemStack((IItemProvider)Items.field_151039_o), new ItemStack((IItemProvider)Items.field_151041_m), new ItemStack((IItemProvider)Items.field_151017_I), new ItemStack((IItemProvider)Items.field_151055_y), new ItemStack((IItemProvider)Items.field_151044_h), new ItemStack((IItemProvider)Items.field_151129_at), new ItemStack((IItemProvider)Blocks.field_196674_t), new ItemStack((IItemProvider)Blocks.field_196675_u), new ItemStack((IItemProvider)Blocks.field_196676_v), new ItemStack((IItemProvider)Blocks.field_196678_w), new ItemStack((IItemProvider)Blocks.field_196679_x), new ItemStack((IItemProvider)Blocks.field_196680_y), new ItemStack((IItemProvider)Items.field_151072_bj), new ItemStack((IItemProvider)Items.field_151038_n), new ItemStack((IItemProvider)Items.field_151053_p)});
    }
}

