/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.network.packet;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import slimeknights.mantle.client.book.BookHelper;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.TileEntityHelper;

public class UpdateLecternPagePacket
implements IThreadsafePacket {
    private final BlockPos pos;
    private final String page;

    public UpdateLecternPagePacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.page = buffer.func_150789_c(100);
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_180714_a(this.page);
    }

    @Override
    public void handleThreadsafe(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player != null && this.page != null) {
            World world = player.func_130014_f_();
            TileEntityHelper.getTile(LecternTileEntity.class, (IBlockReader)world, this.pos).ifPresent(te -> {
                ItemStack stack = te.func_214033_c();
                if (!stack.func_190926_b()) {
                    BookHelper.writeSavedPageToBook(stack, this.page);
                }
            });
        }
    }

    public UpdateLecternPagePacket(BlockPos pos, String page) {
        this.pos = pos;
        this.page = page;
    }
}

