/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.recipe.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;

public class ItemNameIngredient
extends Ingredient {
    private final List<ResourceLocation> names;

    protected ItemNameIngredient(List<ResourceLocation> names) {
        super(Stream.empty());
        this.names = names;
    }

    public static ItemNameIngredient from(List<ResourceLocation> names) {
        return new ItemNameIngredient(names);
    }

    public static ItemNameIngredient from(ResourceLocation ... names) {
        return ItemNameIngredient.from(Arrays.asList(names));
    }

    public boolean test(@Nullable ItemStack stack) {
        throw new UnsupportedOperationException();
    }

    private static JsonObject forName(ResourceLocation name) {
        JsonObject json = new JsonObject();
        json.addProperty("item", name.toString());
        return json;
    }

    public JsonElement func_200304_c() {
        if (this.names.size() == 1) {
            return ItemNameIngredient.forName(this.names.get(0));
        }
        JsonArray array = new JsonArray();
        for (ResourceLocation name : this.names) {
            array.add((JsonElement)ItemNameIngredient.forName(name));
        }
        return array;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return VanillaIngredientSerializer.INSTANCE;
    }
}

