/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.object.ItemObject;

public class BuildingBlockObject
extends ItemObject<Block> {
    private final Supplier<? extends SlabBlock> slab;
    private final Supplier<? extends StairsBlock> stairs;

    public BuildingBlockObject(Block block, Block slab, Block stairs) {
        super(block);
        this.slab = RegistrationHelper.castDelegate(slab.delegate);
        this.stairs = RegistrationHelper.castDelegate(stairs.delegate);
    }

    public BuildingBlockObject(ItemObject<? extends Block> block, Supplier<? extends SlabBlock> slab, Supplier<? extends StairsBlock> stairs) {
        super(block);
        this.slab = slab;
        this.stairs = stairs;
    }

    protected BuildingBlockObject(BuildingBlockObject object) {
        super(object);
        this.slab = object.slab;
        this.stairs = object.stairs;
    }

    public SlabBlock getSlab() {
        return Objects.requireNonNull(this.slab.get(), "Building Block Object missing slab");
    }

    public StairsBlock getStairs() {
        return Objects.requireNonNull(this.stairs.get(), "Building Block Object missing stairs");
    }

    public List<Block> values() {
        return Arrays.asList((Block)this.get(), this.getSlab(), this.getStairs());
    }
}

