/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.integration.waila;

import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.config.WailaConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class HUDHandlerGraveStone
implements IComponentProvider,
IServerDataProvider<BlockEntity> {
    public static final HUDHandlerGraveStone INSTANCE = new HUDHandlerGraveStone();
    private static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof GraveStoneTileEntity) {
            GraveStoneTileEntity grave = (GraveStoneTileEntity)blockEntity;
            if (blockAccessor.getTooltipPosition().equals((Object)TooltipPosition.BODY)) {
                CompoundTag data;
                MutableComponent time = GraveUtils.getDate(grave.getDeath().getTimestamp());
                if (time != null) {
                    iTooltip.add((Component)new TranslatableComponent("message.gravestone.date_of_death", new Object[]{time}));
                }
                if ((data = blockAccessor.getServerData()).m_128441_("ItemCount")) {
                    iTooltip.add((Component)new TranslatableComponent("message.gravestone.item_count", new Object[]{data.m_128451_("ItemCount")}));
                }
            } else if (blockAccessor.getTooltipPosition().equals((Object)TooltipPosition.HEAD)) {
                iTooltip.remove(OBJECT_NAME_TAG);
                iTooltip.add((Component)new TextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getBlockName(), grave.m_7755_().getString())).m_130940_(ChatFormatting.WHITE));
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, BlockEntity blockEntity, boolean b) {
        if (blockEntity instanceof GraveStoneTileEntity) {
            GraveStoneTileEntity grave = (GraveStoneTileEntity)blockEntity;
            compoundTag.m_128405_("ItemCount", (int)grave.getDeath().getAllItems().stream().filter(itemStack -> !itemStack.m_41619_()).count());
        }
    }
}

