/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ghost;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.input.UserInput;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.ItemRenderer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class GhostIngredientDrag<T> {
    private static final int targetColor = 1075038474;
    private static final int hoverColor = -2142451431;
    private final IGhostIngredientHandler<?> handler;
    private final List<IGhostIngredientHandler.Target<T>> targets;
    private final IIngredientRenderer<T> ingredientRenderer;
    private final T ingredient;
    private final double mouseStartX;
    private final double mouseStartY;
    @Nullable
    private final ImmutableRect2i origin;

    public GhostIngredientDrag(IGhostIngredientHandler<?> handler, List<IGhostIngredientHandler.Target<T>> targets, IIngredientRenderer<T> ingredientRenderer, T ingredient, double mouseX, double mouseY, @Nullable ImmutableRect2i origin) {
        this.handler = handler;
        this.targets = targets;
        this.ingredientRenderer = ingredientRenderer;
        this.ingredient = ingredient;
        this.origin = origin;
        this.mouseStartX = mouseX;
        this.mouseStartY = mouseY;
    }

    public void drawTargets(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.handler.shouldHighlightTargets()) {
            GhostIngredientDrag.drawTargets(poseStack, mouseX, mouseY, this.targets);
        }
    }

    public static boolean farEnoughToDraw(GhostIngredientDrag<?> drag, double mouseX, double mouseY) {
        double centerY;
        double centerX;
        ImmutableRect2i origin = drag.getOrigin();
        if (origin != null) {
            centerX = (double)origin.getX() + (double)origin.getWidth() / 2.0;
            centerY = (double)origin.getY() + (double)origin.getHeight() / 2.0;
        } else {
            centerX = drag.mouseStartX;
            centerY = drag.mouseStartY;
        }
        double mouseXDist = centerX - mouseX;
        double mouseYDist = centerY - mouseY;
        double mouseDistSq = mouseXDist * mouseXDist + mouseYDist * mouseYDist;
        return mouseDistSq > 64.0;
    }

    public void drawItem(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        if (!GhostIngredientDrag.farEnoughToDraw(this, mouseX, mouseY)) {
            return;
        }
        if (this.origin != null) {
            int originX = this.origin.getX() + this.origin.getWidth() / 2;
            int originY = this.origin.getY() + this.origin.getHeight() / 2;
            RenderSystem.m_69472_();
            RenderSystem.m_69465_();
            RenderSystem.m_69458_((boolean)false);
            ShaderInstance oldShader = RenderSystem.m_157196_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            GL11.glEnable((int)2848);
            GL11.glHint((int)3154, (int)4354);
            Tesselator tesselator = RenderSystem.m_69883_();
            BufferBuilder builder = tesselator.m_85915_();
            builder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            float red = 0.2509804f;
            float green = 0.07450981f;
            float blue = 0.7882353f;
            float alpha = 0.039215688f;
            builder.m_5483_((double)mouseX, (double)mouseY, 150.0).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_5483_((double)originX, (double)originY, 150.0).m_85950_(red, green, blue, alpha).m_5752_();
            tesselator.m_85914_();
            RenderSystem.m_157427_(() -> oldShader);
            RenderSystem.m_69482_();
            RenderSystem.m_69493_();
            RenderSystem.m_69458_((boolean)true);
        }
        ItemRenderer itemRenderer = minecraft.m_91291_();
        itemRenderer.f_115093_ += 150.0f;
        poseStack.m_85836_();
        poseStack.m_85837_((double)(mouseX - 8), (double)(mouseY - 8), 0.0);
        this.ingredientRenderer.render(poseStack, this.ingredient);
        poseStack.m_85849_();
        itemRenderer.f_115093_ -= 150.0f;
    }

    public static <V> void drawTargets(PoseStack poseStack, int mouseX, int mouseY, List<IGhostIngredientHandler.Target<V>> targets) {
        RenderSystem.m_69465_();
        for (IGhostIngredientHandler.Target<V> target : targets) {
            Rect2i area = target.getArea();
            int color = MathUtil.contains(area, (double)mouseX, (double)mouseY) ? -2142451431 : 1075038474;
            GuiComponent.m_93172_((PoseStack)poseStack, (int)area.m_110085_(), (int)area.m_110086_(), (int)(area.m_110085_() + area.m_110090_()), (int)(area.m_110086_() + area.m_110091_()), (int)color);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean onClick(UserInput input) {
        for (IGhostIngredientHandler.Target<T> target : this.targets) {
            Rect2i area = target.getArea();
            if (!MathUtil.contains(area, input.getMouseX(), input.getMouseY())) continue;
            if (!input.isSimulate()) {
                target.accept(this.ingredient);
                this.handler.onComplete();
            }
            return true;
        }
        if (!input.isSimulate()) {
            this.handler.onComplete();
        }
        return false;
    }

    public void stop() {
        this.handler.onComplete();
    }

    public IIngredientRenderer<T> getIngredientRenderer() {
        return this.ingredientRenderer;
    }

    public T getIngredient() {
        return this.ingredient;
    }

    @Nullable
    public ImmutableRect2i getOrigin() {
        return this.origin;
    }
}

