/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.load.registration;

import com.google.common.collect.ImmutableTable;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.config.Constants;
import mezz.jei.core.collect.Table;
import mezz.jei.recipes.RecipeManager;
import mezz.jei.transfer.BasicRecipeTransferHandler;
import mezz.jei.transfer.BasicRecipeTransferInfo;
import mezz.jei.util.ErrorUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RecipeTransferRegistration
implements IRecipeTransferRegistration {
    private final Table<Class<?>, RecipeType<?>, IRecipeTransferHandler<?, ?>> recipeTransferHandlers = Table.hashBasedTable();
    private final IStackHelper stackHelper;
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final IJeiHelpers jeiHelpers;
    private final RecipeManager recipeManager;
    private final IConnectionToServer serverConnection;

    public RecipeTransferRegistration(IStackHelper stackHelper, IRecipeTransferHandlerHelper handlerHelper, IJeiHelpers jeiHelpers, RecipeManager recipeManager, IConnectionToServer serverConnection) {
        this.stackHelper = stackHelper;
        this.handlerHelper = handlerHelper;
        this.jeiHelpers = jeiHelpers;
        this.recipeManager = recipeManager;
        this.serverConnection = serverConnection;
    }

    @Override
    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    @Override
    public IRecipeTransferHandlerHelper getTransferHelper() {
        return this.handlerHelper;
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(Class<C> containerClass, RecipeType<R> recipeType, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        ErrorUtil.checkNotNull(containerClass, "containerClass");
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        BasicRecipeTransferInfo<C, R> recipeTransferHelper = new BasicRecipeTransferInfo<C, R>(containerClass, recipeType, recipeSlotStart, recipeSlotCount, inventorySlotStart, inventorySlotCount);
        this.addRecipeTransferHandler(recipeTransferHelper);
    }

    @Override
    @Deprecated(forRemoval=true, since="9.5.0")
    public <C extends AbstractContainerMenu> void addRecipeTransferHandler(Class<C> containerClass, ResourceLocation recipeCategoryUid, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        ErrorUtil.checkNotNull(containerClass, "containerClass");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        RecipeType<?> recipeType = this.recipeManager.getRecipeType(recipeCategoryUid);
        BasicRecipeTransferInfo recipeTransferHelper = new BasicRecipeTransferInfo(containerClass, recipeType, recipeSlotStart, recipeSlotCount, inventorySlotStart, inventorySlotCount);
        this.addRecipeTransferHandler(recipeTransferHelper);
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(IRecipeTransferInfo<C, R> recipeTransferInfo) {
        ErrorUtil.checkNotNull(recipeTransferInfo, "recipeTransferInfo");
        BasicRecipeTransferHandler<C, R> recipeTransferHandler = new BasicRecipeTransferHandler<C, R>(this.serverConnection, this.stackHelper, this.handlerHelper, recipeTransferInfo);
        this.addRecipeTransferHandler(recipeTransferHandler, recipeTransferInfo.getRecipeType());
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(IRecipeTransferHandler<C, R> recipeTransferHandler, RecipeType<R> recipeType) {
        ErrorUtil.checkNotNull(recipeTransferHandler, "recipeTransferHandler");
        ErrorUtil.checkNotNull(recipeType, "recipeType");
        Class<C> containerClass = recipeTransferHandler.getContainerClass();
        this.recipeTransferHandlers.put(containerClass, recipeType, recipeTransferHandler);
    }

    @Override
    @Deprecated(forRemoval=true, since="9.5.0")
    public <C extends AbstractContainerMenu, R> void addRecipeTransferHandler(IRecipeTransferHandler<C, R> recipeTransferHandler, ResourceLocation recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeTransferHandler, "recipeTransferHandler");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        Class<C> containerClass = recipeTransferHandler.getContainerClass();
        RecipeType<?> recipeType = this.recipeManager.getRecipeType(recipeCategoryUid);
        this.recipeTransferHandlers.put(containerClass, recipeType, recipeTransferHandler);
    }

    @Override
    public <C extends AbstractContainerMenu, R> void addUniversalRecipeTransferHandler(IRecipeTransferHandler<C, R> recipeTransferHandler) {
        ErrorUtil.checkNotNull(recipeTransferHandler, "recipeTransferHandler");
        Class<C> containerClass = recipeTransferHandler.getContainerClass();
        this.recipeTransferHandlers.put(containerClass, Constants.UNIVERSAL_RECIPE_TRANSFER_TYPE, recipeTransferHandler);
    }

    public ImmutableTable<Class<?>, RecipeType<?>, IRecipeTransferHandler<?, ?>> getRecipeTransferHandlers() {
        return this.recipeTransferHandlers.toImmutable();
    }
}

