/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeCategoriesLookup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.recipes.FocusGroup;
import mezz.jei.recipes.RecipeManagerInternal;
import mezz.jei.util.ErrorUtil;

public class RecipeCategoriesLookup
implements IRecipeCategoriesLookup {
    private final RecipeManagerInternal recipeManager;
    private boolean includeHidden = false;
    private Collection<RecipeType<?>> recipeTypes = List.of();
    private IFocusGroup focusGroup = FocusGroup.EMPTY;

    public RecipeCategoriesLookup(RecipeManagerInternal recipeManager) {
        this.recipeManager = recipeManager;
    }

    @Override
    public IRecipeCategoriesLookup limitTypes(Collection<RecipeType<?>> recipeTypes) {
        ErrorUtil.checkNotNull(recipeTypes, "recipeTypes");
        this.recipeTypes = recipeTypes;
        return this;
    }

    @Override
    public IRecipeCategoriesLookup limitFocus(Collection<? extends IFocus<?>> focuses) {
        ErrorUtil.checkNotNull(focuses, "focuses");
        this.focusGroup = FocusGroup.create(focuses);
        return this;
    }

    @Override
    public IRecipeCategoriesLookup includeHidden() {
        this.includeHidden = true;
        return this;
    }

    @Override
    public Stream<IRecipeCategory<?>> get() {
        return this.recipeManager.getRecipeCategoriesForTypes(this.recipeTypes, this.focusGroup, this.includeHidden);
    }
}

