/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.recipes.RecipeTypeData;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Unmodifiable;

public class RecipeTypeDataMap {
    private final @Unmodifiable Map<ResourceLocation, RecipeTypeData<?>> uidMap;

    public RecipeTypeDataMap(List<IRecipeCategory<?>> recipeCategories, ImmutableListMultimap<IRecipeCategory<?>, ITypedIngredient<?>> recipeCategoryCatalystsMap) {
        this.uidMap = recipeCategories.stream().collect(Collectors.toUnmodifiableMap(recipeCategory -> recipeCategory.getRecipeType().getUid(), recipeCategory -> {
            ImmutableList catalysts = recipeCategoryCatalystsMap.get(recipeCategory);
            return new RecipeTypeData(recipeCategory, (List<ITypedIngredient<?>>)catalysts);
        }));
    }

    public RecipeTypeData<?> get(ResourceLocation recipeCategoryUid) {
        RecipeTypeData<?> recipeTypeData = this.uidMap.get(recipeCategoryUid);
        if (recipeTypeData == null) {
            throw new IllegalStateException("There is no recipe category registered for: " + recipeCategoryUid);
        }
        return recipeTypeData;
    }

    public <T> RecipeTypeData<T> get(RecipeType<T> recipeType) {
        ResourceLocation uid = recipeType.getUid();
        RecipeTypeData<?> recipeTypeData = this.get(uid);
        return recipeTypeData;
    }

    public <T> RecipeTypeData<T> get(Iterable<T> recipes, ResourceLocation recipeCategoryUid) {
        RecipeTypeData<?> recipeTypeData = this.get(recipeCategoryUid);
        return RecipeTypeDataMap.validate(recipes, recipeTypeData);
    }

    public <T> RecipeTypeData<T> get(Iterable<? extends T> recipes, RecipeType<T> recipeType) {
        RecipeTypeData<T> recipeTypeData = this.get(recipeType);
        return RecipeTypeDataMap.validate(recipes, recipeTypeData);
    }

    public <T> RecipeTypeData<T> get(T recipe, RecipeType<T> recipeType) {
        RecipeTypeData<T> recipeTypeData = this.get(recipeType);
        return RecipeTypeDataMap.validate(List.of(recipe), recipeTypeData);
    }

    public <T> RecipeTypeData<T> get(T recipe, ResourceLocation recipeCategoryUid) {
        RecipeTypeData<?> recipeTypeData = this.get(recipeCategoryUid);
        return RecipeTypeDataMap.validate(List.of(recipe), recipeTypeData);
    }

    private static <T> RecipeTypeData<T> validate(Iterable<? extends T> recipes, RecipeTypeData<?> recipeTypeData) {
        IRecipeCategory<?> recipeCategory = recipeTypeData.getRecipeCategory();
        RecipeType<?> recipeType = recipeCategory.getRecipeType();
        Class<?> recipeClass = recipeType.getRecipeClass();
        for (T recipe : recipes) {
            if (recipeClass.isInstance(recipe)) continue;
            throw new IllegalArgumentException(recipeType.getUid() + " recipes must be an instance of " + recipeClass + ". Instead got: " + recipe.getClass());
        }
        RecipeTypeData<?> castRecipeTypeData = recipeTypeData;
        return castRecipeTypeData;
    }

    public void validate(ResourceLocation recipeCategoryUid) {
        if (!this.uidMap.containsKey(recipeCategoryUid)) {
            throw new IllegalStateException("There is no recipe category registered for: " + recipeCategoryUid);
        }
    }
}

