/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.transfer;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.Internal;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.common.transfer.TransferOperation;
import mezz.jei.common.util.ItemStackMatchable;
import mezz.jei.common.util.MatchingIterable;
import mezz.jei.common.util.StringUtil;
import mezz.jei.gui.ingredients.RecipeSlots;
import mezz.jei.gui.recipes.RecipeLayout;
import mezz.jei.recipes.RecipeTransferManager;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.transfer.RecipeTransferErrorInternal;
import mezz.jei.transfer.RecipeTransferOperationsResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class RecipeTransferUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private RecipeTransferUtil() {
    }

    @Nullable
    public static IRecipeTransferError getTransferRecipeError(RecipeTransferManager recipeTransferManager, AbstractContainerMenu container, RecipeLayout<?> recipeLayout, Player player) {
        return RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, false, false);
    }

    public static boolean transferRecipe(RecipeTransferManager recipeTransferManager, AbstractContainerMenu container, RecipeLayout<?> recipeLayout, Player player, boolean maxTransfer) {
        IRecipeTransferError error = RecipeTransferUtil.transferRecipe(recipeTransferManager, container, recipeLayout, player, maxTransfer, true);
        return RecipeTransferUtil.allowsTransfer(error);
    }

    @Nullable
    private static <C extends AbstractContainerMenu, R> IRecipeTransferError transferRecipe(RecipeTransferManager recipeTransferManager, C container, RecipeLayout<R> recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        JeiRuntime runtime = Internal.getRuntime();
        if (runtime == null) {
            return RecipeTransferErrorInternal.INSTANCE;
        }
        IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
        IRecipeTransferHandler<C, R> transferHandler = recipeTransferManager.getRecipeTransferHandler(container, recipeCategory);
        if (transferHandler == null) {
            if (doTransfer) {
                LOGGER.error("No Recipe Transfer handler for container {}", container.getClass());
            }
            return RecipeTransferErrorInternal.INSTANCE;
        }
        RecipeSlots recipeSlots = recipeLayout.getRecipeSlots();
        IRecipeSlotsView recipeSlotsView = recipeSlots.getView();
        try {
            return transferHandler.transferRecipe(container, recipeLayout.getRecipe(), recipeSlotsView, player, maxTransfer, doTransfer);
        }
        catch (UnsupportedOperationException ignored) {
            return transferHandler.transferRecipe(container, recipeLayout.getRecipe(), recipeLayout.getLegacyAdapter(), player, maxTransfer, doTransfer);
        }
    }

    public static boolean allowsTransfer(@Nullable IRecipeTransferError error) {
        return error == null || error.getType() == IRecipeTransferError.Type.COSMETIC;
    }

    public static boolean validateSlots(Player player, Collection<TransferOperation> transferOperations, Collection<Slot> craftingSlots, Collection<Slot> inventorySlots) {
        Set<Integer> inventorySlotIndexes = inventorySlots.stream().map(s -> s.f_40219_).collect(Collectors.toSet());
        Set<Integer> craftingSlotIndexes = craftingSlots.stream().map(s -> s.f_40219_).collect(Collectors.toSet());
        List<Integer> invalidRecipeIndexes = transferOperations.stream().map(TransferOperation::craftingSlot).map(s -> s.f_40219_).filter(s -> !craftingSlotIndexes.contains(s)).toList();
        if (!invalidRecipeIndexes.isEmpty()) {
            LOGGER.error("Transfer handler has invalid slots for the destination of the recipe, the slots are not included in the list of crafting slots. " + StringUtil.intsToString(invalidRecipeIndexes));
            return false;
        }
        List<Integer> invalidInventorySlotIndexes = transferOperations.stream().map(TransferOperation::inventorySlot).map(s -> s.f_40219_).filter(s -> !inventorySlotIndexes.contains(s) && !craftingSlotIndexes.contains(s)).toList();
        if (!invalidInventorySlotIndexes.isEmpty()) {
            LOGGER.error("Transfer handler has invalid source slots for the inventory stacks for the recipe, the slots are not included in the list of inventory slots or recipe slots. " + StringUtil.intsToString(invalidInventorySlotIndexes) + "\n inventory slots: " + StringUtil.intsToString(inventorySlotIndexes) + "\n crafting slots: " + StringUtil.intsToString(craftingSlotIndexes));
            return false;
        }
        Set<Integer> overlappingSlots = inventorySlotIndexes.stream().filter(craftingSlotIndexes::contains).collect(Collectors.toSet());
        if (!overlappingSlots.isEmpty()) {
            LOGGER.error("Transfer handler has invalid slots, inventorySlots and craftingSlots should not share any slot, but both have: " + StringUtil.intsToString(overlappingSlots));
            return false;
        }
        List<Integer> invalidPickupSlots = Stream.concat(craftingSlots.stream(), inventorySlots.stream()).filter(Slot::m_6657_).filter(slot -> !slot.m_8010_(player)).map(slot -> slot.f_40219_).toList();
        if (!invalidPickupSlots.isEmpty()) {
            LOGGER.error("Transfer handler has invalid slots, the player is unable to pickup from them: " + StringUtil.intsToString(invalidPickupSlots));
            return false;
        }
        return true;
    }

    public static RecipeTransferOperationsResult getRecipeTransferOperations(IStackHelper stackhelper, Map<Slot, ItemStack> availableItemStacks, List<IRecipeSlotView> requiredItemStacks, List<Slot> craftingSlots) {
        RecipeTransferOperationsResult transferOperations = new RecipeTransferOperationsResult();
        for (int i = 0; i < requiredItemStacks.size(); ++i) {
            IRecipeSlotView requiredItemStack = requiredItemStacks.get(i);
            if (requiredItemStack.isEmpty()) continue;
            Slot craftingSlot = craftingSlots.get(i);
            Map.Entry<Slot, ItemStack> matching = RecipeTransferUtil.containsAnyStackIndexed(stackhelper, availableItemStacks, requiredItemStack);
            if (matching == null) {
                transferOperations.missingItems.add(requiredItemStack);
                continue;
            }
            Slot matchingSlot = matching.getKey();
            ItemStack matchingStack = matching.getValue();
            matchingStack.m_41774_(1);
            if (matchingStack.m_41619_()) {
                availableItemStacks.remove(matchingSlot);
            }
            transferOperations.results.add(new TransferOperation(matchingSlot, craftingSlot));
        }
        return transferOperations;
    }

    @Nullable
    public static <T> Map.Entry<T, ItemStack> containsAnyStackIndexed(IStackHelper stackhelper, Map<T, ItemStack> stacks, IRecipeSlotView recipeSlotView) {
        MatchingIndexed<T> matchingStacks = new MatchingIndexed<T>(stacks);
        List<ItemStack> ingredients = recipeSlotView.getIngredients(VanillaTypes.ITEM_STACK).toList();
        MatchingIterable matchingContains = new MatchingIterable(ingredients);
        return (Map.Entry)RecipeTransferUtil.containsStackMatchable(stackhelper, matchingStacks, matchingContains);
    }

    @Nullable
    public static <R, T> R containsStackMatchable(IStackHelper stackhelper, Iterable<ItemStackMatchable<R>> stacks, Iterable<ItemStackMatchable<T>> contains) {
        for (ItemStackMatchable<T> containStack : contains) {
            R matchingStack = RecipeTransferUtil.containsStack(stackhelper, stacks, containStack);
            if (matchingStack == null) continue;
            return matchingStack;
        }
        return null;
    }

    @Nullable
    public static <R> R containsStack(IStackHelper stackHelper, Iterable<ItemStackMatchable<R>> stacks, ItemStackMatchable<?> contains) {
        for (ItemStackMatchable<R> stack : stacks) {
            if (!stackHelper.isEquivalent(contains.getStack(), stack.getStack(), UidContext.Recipe)) continue;
            return stack.getResult();
        }
        return null;
    }

    private static class MatchingIndexed<T>
    implements Iterable<ItemStackMatchable<Map.Entry<T, ItemStack>>> {
        private final Map<T, ItemStack> map;

        public MatchingIndexed(Map<T, ItemStack> map) {
            this.map = map;
        }

        @Override
        public Iterator<ItemStackMatchable<Map.Entry<T, ItemStack>>> iterator() {
            return new MatchingIterable.DelegateIterator<Map.Entry<T, ItemStack>, ItemStackMatchable<Map.Entry<T, ItemStack>>>(this.map.entrySet().iterator()){

                @Override
                public ItemStackMatchable<Map.Entry<T, ItemStack>> next() {
                    final Map.Entry entry = (Map.Entry)this.delegate.next();
                    return new ItemStackMatchable<Map.Entry<T, ItemStack>>(){

                        @Override
                        public ItemStack getStack() {
                            return (ItemStack)entry.getValue();
                        }

                        @Override
                        public Map.Entry<T, ItemStack> getResult() {
                            return entry;
                        }
                    };
                }
            };
        }
    }
}

