/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.blocks.ComputerPeripheral;
import dan200.computercraft.shared.computer.blocks.ComputerProxy;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.turtle.apis.TurtleAPI;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import dan200.computercraft.shared.turtle.blocks.ITurtleTile;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.inventory.ContainerTurtle;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.DefaultInventory;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileTurtle
extends TileComputerBase
implements ITurtleTile,
DefaultInventory {
    public static final int INVENTORY_SIZE = 16;
    public static final int INVENTORY_WIDTH = 4;
    public static final int INVENTORY_HEIGHT = 4;
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)16, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> previousInventory = NonNullList.m_122780_((int)16, (Object)ItemStack.f_41583_);
    private final IItemHandlerModifiable itemHandler = new InvWrapper((Container)this);
    private LazyOptional<IItemHandlerModifiable> itemHandlerCap;
    private boolean inventoryChanged = false;
    private TurtleBrain brain = new TurtleBrain(this);
    private MoveState moveState = MoveState.NOT_MOVED;
    private LazyOptional<IPeripheral> peripheral;

    public TileTurtle(BlockEntityType<? extends TileGeneric> type, BlockPos pos, BlockState state, ComputerFamily family) {
        super(type, pos, state, family);
    }

    private boolean hasMoved() {
        return this.moveState == MoveState.MOVED;
    }

    @Override
    protected ServerComputer createComputer(int id) {
        ServerComputer computer = new ServerComputer((ServerLevel)this.m_58904_(), id, this.label, this.getFamily(), 39, 13);
        computer.setPosition(this.m_58899_());
        computer.addAPI(new TurtleAPI(computer.getAPIEnvironment(), this.getAccess()));
        this.brain.setupComputer(computer);
        return computer;
    }

    public ComputerProxy createProxy() {
        return this.brain.getProxy();
    }

    @Override
    public void destroy() {
        block3: {
            block2: {
                if (this.hasMoved()) break block2;
                super.destroy();
                if (this.m_58904_().f_46443_) break block3;
                int size = this.m_6643_();
                for (int i = 0; i < size; ++i) {
                    ItemStack stack = this.m_8020_(i);
                    if (stack.m_41619_()) continue;
                    WorldUtil.dropItemStack(stack, this.m_58904_(), this.m_58899_());
                }
                break block3;
            }
            for (Direction dir : DirectionUtil.FACINGS) {
                RedstoneUtil.propagateRedstoneOutput(this.m_58904_(), this.m_58899_(), dir);
            }
        }
    }

    @Override
    protected void unload() {
        if (!this.hasMoved()) {
            super.unload();
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerCap = CapabilityUtil.invalidate(this.itemHandlerCap);
        this.peripheral = CapabilityUtil.invalidate(this.peripheral);
    }

    @Override
    @Nonnull
    public InteractionResult onActivate(Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack currentItem = player.m_21120_(hand);
        if (!currentItem.m_41619_()) {
            Item item = currentItem.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                if (!this.m_58904_().f_46443_) {
                    DyeColor dye = dyeItem.m_41089_();
                    if (this.brain.getDyeColour() != dye) {
                        this.brain.setDyeColour(dye);
                        if (!player.m_7500_()) {
                            currentItem.m_41774_(1);
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (currentItem.m_41720_() == Items.f_42447_ && this.brain.getColour() != -1) {
                if (!this.m_58904_().f_46443_ && this.brain.getColour() != -1) {
                    this.brain.setColour(-1);
                    if (!player.m_7500_()) {
                        player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                        player.m_150109_().m_6596_();
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.onActivate(player, hand, hit);
    }

    @Override
    protected boolean canNameWithTag(Player player) {
        return true;
    }

    @Override
    protected double getInteractRange(Player player) {
        return 12.0;
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        this.brain.update();
        if (this.inventoryChanged) {
            ServerComputer computer = this.getServerComputer();
            if (computer != null) {
                computer.queueEvent("turtle_inventory");
            }
            this.inventoryChanged = false;
            for (int n = 0; n < this.m_6643_(); ++n) {
                this.previousInventory.set(n, (Object)this.m_8020_(n).m_41777_());
            }
        }
    }

    protected void clientTick() {
        this.brain.update();
    }

    @Override
    protected void updateBlockState(ComputerState newState) {
    }

    @Override
    public void onNeighbourChange(@Nonnull BlockPos neighbour) {
        if (this.moveState == MoveState.NOT_MOVED) {
            super.onNeighbourChange(neighbour);
        }
    }

    @Override
    public void onNeighbourTileEntityChange(@Nonnull BlockPos neighbour) {
        if (this.moveState == MoveState.NOT_MOVED) {
            super.onNeighbourTileEntityChange(neighbour);
        }
    }

    public void notifyMoveStart() {
        if (this.moveState == MoveState.NOT_MOVED) {
            this.moveState = MoveState.IN_PROGRESS;
        }
    }

    public void notifyMoveEnd() {
        if (this.moveState == MoveState.IN_PROGRESS) {
            this.moveState = MoveState.NOT_MOVED;
        }
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        ListTag nbttaglist = nbt.m_128437_("Items", 10);
        this.inventory.clear();
        this.previousInventory.clear();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundTag tag = nbttaglist.m_128728_(i);
            int slot = tag.m_128445_("Slot") & 0xFF;
            if (slot >= this.m_6643_()) continue;
            this.inventory.set(slot, (Object)ItemStack.m_41712_((CompoundTag)tag));
            this.previousInventory.set(slot, (Object)((ItemStack)this.inventory.get(slot)).m_41777_());
        }
        this.brain.readFromNBT(nbt);
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbt) {
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < 16; ++i) {
            if (((ItemStack)this.inventory.get(i)).m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("Slot", (byte)i);
            ((ItemStack)this.inventory.get(i)).m_41739_(tag);
            nbttaglist.add((Object)tag);
        }
        nbt.m_128365_("Items", (Tag)nbttaglist);
        nbt = this.brain.writeToNBT(nbt);
        super.m_183515_(nbt);
    }

    @Override
    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return this.hasPeripheralUpgradeOnSide(localSide);
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockTurtle.FACING);
    }

    public void setDirection(Direction dir) {
        if (dir.m_122434_() == Direction.Axis.Y) {
            dir = Direction.NORTH;
        }
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockTurtle.FACING, (Comparable)dir));
        this.updateOutput();
        this.updateInputsImmediately();
        this.onTileEntityChange();
    }

    @Override
    public ITurtleUpgrade getUpgrade(TurtleSide side) {
        return this.brain.getUpgrade(side);
    }

    @Override
    public int getColour() {
        return this.brain.getColour();
    }

    @Override
    public ResourceLocation getOverlay() {
        return this.brain.getOverlay();
    }

    @Override
    public ITurtleAccess getAccess() {
        return this.brain;
    }

    @Override
    public Vec3 getRenderOffset(float f) {
        return this.brain.getRenderOffset(f);
    }

    @Override
    public float getRenderYaw(float f) {
        return this.brain.getVisualYaw(f);
    }

    @Override
    public float getToolRenderAngle(TurtleSide side, float f) {
        return this.brain.getToolRenderAngle(side, f);
    }

    void setOwningPlayer(GameProfile player) {
        this.brain.setOwningPlayer(player);
        this.m_6596_();
    }

    public int m_6643_() {
        return 16;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.inventory) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack m_8020_(int slot) {
        return slot >= 0 && slot < 16 ? (ItemStack)this.inventory.get(slot) : ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack m_8016_(int slot) {
        ItemStack result = this.m_8020_(slot);
        this.m_6836_(slot, ItemStack.f_41583_);
        return result;
    }

    @Nonnull
    public ItemStack m_7407_(int slot, int count) {
        if (count == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = this.m_8020_(slot);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41613_() <= count) {
            this.m_6836_(slot, ItemStack.f_41583_);
            return stack;
        }
        ItemStack part = stack.m_41620_(count);
        this.onInventoryDefinitelyChanged();
        return part;
    }

    public void m_6836_(int i, @Nonnull ItemStack stack) {
        if (i >= 0 && i < 16 && !InventoryUtil.areItemsEqual(stack, (ItemStack)this.inventory.get(i))) {
            this.inventory.set(i, (Object)stack);
            this.onInventoryDefinitelyChanged();
        }
    }

    public void m_6211_() {
        boolean changed = false;
        for (int i = 0; i < 16; ++i) {
            if (((ItemStack)this.inventory.get(i)).m_41619_()) continue;
            this.inventory.set(i, (Object)ItemStack.f_41583_);
            changed = true;
        }
        if (changed) {
            this.onInventoryDefinitelyChanged();
        }
    }

    public void m_6596_() {
        super.m_6596_();
        if (!this.inventoryChanged) {
            for (int n = 0; n < this.m_6643_(); ++n) {
                if (ItemStack.m_41728_((ItemStack)this.m_8020_(n), (ItemStack)((ItemStack)this.previousInventory.get(n)))) continue;
                this.inventoryChanged = true;
                break;
            }
        }
    }

    public boolean m_6542_(@Nonnull Player player) {
        return this.isUsable(player);
    }

    private void onInventoryDefinitelyChanged() {
        super.m_6596_();
        this.inventoryChanged = true;
    }

    public void onTileEntityChange() {
        super.m_6596_();
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.brain.writeDescription(nbt);
        return nbt;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        this.brain.readDescription(nbt);
    }

    private boolean hasPeripheralUpgradeOnSide(ComputerSide side) {
        ITurtleUpgrade upgrade;
        switch (side) {
            case RIGHT: {
                upgrade = this.getUpgrade(TurtleSide.RIGHT);
                break;
            }
            case LEFT: {
                upgrade = this.getUpgrade(TurtleSide.LEFT);
                break;
            }
            default: {
                return false;
            }
        }
        return upgrade != null && upgrade.getType().isPeripheral();
    }

    public void transferStateFrom(TileTurtle copy) {
        super.transferStateFrom(copy);
        Collections.copy(this.inventory, copy.inventory);
        Collections.copy(this.previousInventory, copy.previousInventory);
        this.inventoryChanged = copy.inventoryChanged;
        this.brain = copy.brain;
        this.brain.setOwner(this);
        copy.moveState = MoveState.MOVED;
        copy.peripheral = CapabilityUtil.invalidate(copy.peripheral);
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.itemHandlerCap == null) {
                this.itemHandlerCap = LazyOptional.of(() -> new InvWrapper((Container)this));
            }
            return this.itemHandlerCap.cast();
        }
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.hasMoved()) {
                return LazyOptional.empty();
            }
            if (this.peripheral == null) {
                this.peripheral = LazyOptional.of(() -> new ComputerPeripheral("turtle", this.createProxy()));
            }
            return this.peripheral.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
        return ContainerTurtle.ofBrain(id, inventory, this.brain);
    }

    static enum MoveState {
        NOT_MOVED,
        IN_PROGRESS,
        MOVED;

    }
}

