/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.client.TransformedModel;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TurtleModem
extends AbstractTurtleUpgrade {
    private final boolean advanced;
    private final ResourceLocation leftOffModel;
    private final ResourceLocation rightOffModel;
    private final ResourceLocation leftOnModel;
    private final ResourceLocation rightOnModel;

    public TurtleModem(ResourceLocation id, ItemStack stack, boolean advanced) {
        super(id, TurtleUpgradeType.PERIPHERAL, advanced ? "upgrade.computercraft.wireless_modem_advanced.adjective" : "upgrade.computercraft.wireless_modem_normal.adjective", stack);
        this.advanced = advanced;
        if (advanced) {
            this.leftOffModel = new ResourceLocation("computercraft", "block/turtle_modem_advanced_off_left");
            this.rightOffModel = new ResourceLocation("computercraft", "block/turtle_modem_advanced_off_right");
            this.leftOnModel = new ResourceLocation("computercraft", "block/turtle_modem_advanced_on_left");
            this.rightOnModel = new ResourceLocation("computercraft", "block/turtle_modem_advanced_on_right");
        } else {
            this.leftOffModel = new ResourceLocation("computercraft", "turtle_modem_normal_off_left");
            this.rightOffModel = new ResourceLocation("computercraft", "block/turtle_modem_normal_off_right");
            this.leftOnModel = new ResourceLocation("computercraft", "block/turtle_modem_normal_on_left");
            this.rightOnModel = new ResourceLocation("computercraft", "block/turtle_modem_normal_on_right");
        }
    }

    @Override
    public IPeripheral createPeripheral(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return new Peripheral(turtle, this.advanced);
    }

    @Override
    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull Direction dir) {
        return TurtleCommandResult.failure();
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TransformedModel getModel(ITurtleAccess turtle, @Nonnull TurtleSide side) {
        boolean active = false;
        if (turtle != null) {
            CompoundTag turtleNBT = turtle.getUpgradeNBTData(side);
            boolean bl = active = turtleNBT.m_128441_("active") && turtleNBT.m_128471_("active");
        }
        return side == TurtleSide.LEFT ? TransformedModel.of(active ? this.leftOnModel : this.leftOffModel) : TransformedModel.of(active ? this.rightOnModel : this.rightOffModel);
    }

    @Override
    public void update(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        Peripheral modem;
        ModemState state;
        IPeripheral peripheral;
        if (!turtle.getLevel().f_46443_ && (peripheral = turtle.getPeripheral(side)) instanceof Peripheral && (state = (modem = (Peripheral)peripheral).getModemState()).pollChanged()) {
            turtle.getUpgradeNBTData(side).m_128379_("active", state.isOpen());
            turtle.updateUpgradeNBTData(side);
        }
    }

    private static class Peripheral
    extends WirelessModemPeripheral {
        private final ITurtleAccess turtle;

        Peripheral(ITurtleAccess turtle, boolean advanced) {
            super(new ModemState(), advanced);
            this.turtle = turtle;
        }

        @Override
        @Nonnull
        public Level getLevel() {
            return this.turtle.getLevel();
        }

        @Override
        @Nonnull
        public Vec3 getPosition() {
            BlockPos turtlePos = this.turtle.getPosition();
            return new Vec3((double)turtlePos.m_123341_(), (double)turtlePos.m_123342_(), (double)turtlePos.m_123343_());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(IPeripheral other) {
            if (this == other) return true;
            if (!(other instanceof Peripheral)) return false;
            Peripheral modem = (Peripheral)other;
            if (modem.turtle != this.turtle) return false;
            return true;
        }
    }
}

