/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.fission;

import java.util.List;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class FissionReactorCache
extends MultiblockCache<FissionReactorMultiblockData> {
    private double reactorDamage;
    private double rateLimit = -1.0;
    private double burnRemaining;
    private double partialWaste;
    private boolean active;
    private boolean forceDisable;

    private double getRateLimit() {
        if (this.rateLimit == -1.0) {
            return MekanismGeneratorsConfig.generators.defaultBurnRate.get();
        }
        return this.rateLimit;
    }

    public void merge(MultiblockCache<FissionReactorMultiblockData> mergeCache, List<ItemStack> rejectedItems) {
        super.merge(mergeCache, rejectedItems);
        this.reactorDamage = Math.max(this.reactorDamage, ((FissionReactorCache)mergeCache).reactorDamage);
        this.rateLimit = Math.max(this.rateLimit, ((FissionReactorCache)mergeCache).rateLimit);
        this.burnRemaining += ((FissionReactorCache)mergeCache).burnRemaining;
        this.partialWaste += ((FissionReactorCache)mergeCache).partialWaste;
        this.active |= ((FissionReactorCache)mergeCache).active;
        this.forceDisable |= ((FissionReactorCache)mergeCache).forceDisable;
    }

    public void apply(FissionReactorMultiblockData data) {
        super.apply((MultiblockData)data);
        data.reactorDamage = this.reactorDamage;
        data.rateLimit = this.getRateLimit();
        data.burnRemaining = this.burnRemaining;
        data.partialWaste = this.partialWaste;
        data.setForceDisable(this.forceDisable);
        data.setActive(this.active);
    }

    public void sync(FissionReactorMultiblockData data) {
        super.sync((MultiblockData)data);
        this.reactorDamage = data.reactorDamage;
        this.rateLimit = data.rateLimit;
        this.burnRemaining = data.burnRemaining;
        this.partialWaste = data.partialWaste;
        this.forceDisable = data.isForceDisabled();
        this.active = data.isActive();
    }

    public void load(CompoundTag nbtTags) {
        super.load(nbtTags);
        this.reactorDamage = nbtTags.m_128459_("reactorDamage");
        NBTUtils.setDoubleIfPresent((CompoundTag)nbtTags, (String)"injectionRate", value -> {
            this.rateLimit = value;
        });
        this.burnRemaining = nbtTags.m_128459_("burnTime");
        this.partialWaste = nbtTags.m_128459_("partialWaste");
        this.forceDisable = nbtTags.m_128471_("disabled");
        this.active = nbtTags.m_128471_("active");
    }

    public void save(CompoundTag nbtTags) {
        super.save(nbtTags);
        nbtTags.m_128347_("reactorDamage", this.reactorDamage);
        nbtTags.m_128347_("injectionRate", this.getRateLimit());
        nbtTags.m_128347_("burnTime", this.burnRemaining);
        nbtTags.m_128347_("partialWaste", this.partialWaste);
        nbtTags.m_128379_("disabled", this.forceDisable);
        nbtTags.m_128379_("active", this.active);
    }
}

