/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.lib.util.Constants;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;

public class GlossedMagmaBlock
extends MagmaBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)3);

    public GlossedMagmaBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        Material material;
        super.m_6240_(worldIn, player, pos, state, te, stack);
        if (Utils.getItemEnchantmentLevel(Enchantments.f_44985_, stack) == 0 && ((material = worldIn.m_8055_(pos.m_7495_()).m_60767_()).m_76334_() || material.m_76332_())) {
            worldIn.m_46597_(pos, Blocks.f_49991_.m_49966_());
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (blockIn == this && this.shouldMelt((BlockGetter)worldIn, pos, 2)) {
            this.turnIntoLava(state, worldIn, pos);
        }
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        this.m_7458_(state, worldIn, pos, random);
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if ((rand.nextInt(9) == 0 || this.shouldMelt((BlockGetter)worldIn, pos, 4)) && this.slightlyMelt(state, (Level)worldIn, pos)) {
            BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
            for (Direction direction : Constants.DIRECTIONS) {
                blockpos$mutable.m_122159_((Vec3i)pos, direction);
                BlockState blockstate = worldIn.m_8055_((BlockPos)blockpos$mutable);
                if (!blockstate.m_60713_((Block)this) || this.slightlyMelt(blockstate, (Level)worldIn, (BlockPos)blockpos$mutable)) continue;
                worldIn.m_186460_((BlockPos)blockpos$mutable, (Block)this, Mth.m_14072_((Random)rand, (int)20, (int)40));
            }
        } else {
            worldIn.m_186460_(pos, (Block)this, MathHelper.nextInt(rand, 20, 40));
        }
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return ItemStack.f_41583_;
    }

    protected void turnIntoLava(BlockState state, Level worldIn, BlockPos pos) {
        worldIn.m_46597_(pos, Blocks.f_49991_.m_49966_());
        worldIn.m_46586_(pos, Blocks.f_49991_, pos);
    }

    protected boolean shouldMelt(BlockGetter worldIn, BlockPos pos, int neighborsRequired) {
        int i = 0;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Constants.DIRECTIONS) {
            blockpos$mutable.m_122159_((Vec3i)pos, direction);
            if (!worldIn.m_8055_((BlockPos)blockpos$mutable).m_60713_((Block)this) || ++i < neighborsRequired) continue;
            return false;
        }
        return true;
    }

    protected boolean slightlyMelt(BlockState state, Level worldIn, BlockPos pos) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 3) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            return false;
        }
        this.turnIntoLava(state, worldIn, pos);
        return true;
    }
}

