/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle;

import cofh.core.client.particle.LevelMatrixStackParticle;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.SplittableRandom;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlastWaveParticle
extends LevelMatrixStackParticle {
    protected float fLifetime;
    protected int seed;

    private BlastWaveParticle(ClientLevel levelIn, double xCoordIn, double yCoordIn, double zCoordIn, double speed, double width, double heightScale) {
        super(levelIn, xCoordIn, yCoordIn, zCoordIn, width, speed, heightScale);
        this.fLifetime = (float)(width / speed);
        this.f_107225_ = MathHelper.ceil(this.fLifetime);
        this.m_107250_((float)width, (float)heightScale);
        this.f_107219_ = false;
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, int packedLightIn, float partialTicks) {
        SplittableRandom rand = new SplittableRandom(this.seed);
        float time = (float)this.f_107224_ + partialTicks;
        float progress = time / this.fLifetime;
        float easeSin = MathHelper.sin(progress * (float)Math.PI * 0.5f);
        float easeCub = MathHelper.easeOutCubic(progress);
        VFXHelper.renderCyclone(stack, buffer, this.m_6355_(partialTicks), this.f_107221_ * 0.5f * easeSin, this.f_107222_ * easeSin, 2, 0.2f * easeCub, time * 0.05f + (float)rand.nextDouble(69.0), 0.5f * MathHelper.easePlateau(progress));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet sprite) {
        }

        @Nullable
        public Particle createParticle(SimpleParticleType data, ClientLevel level, double x, double y, double z, double speed, double radius, double heightScale) {
            return new BlastWaveParticle(level, x, y, z, speed, radius, heightScale);
        }
    }
}

