/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.client.sounds;

import cofh.lib.util.Constants;
import java.util.function.Supplier;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ConditionalSoundInstance
extends AbstractTickableSoundInstance {
    boolean beginFadeOut;
    boolean donePlaying;
    int ticks = 0;
    int fadeIn = 50;
    int fadeOut = 50;
    float baseVolume = 1.0f;
    Supplier<Boolean> condition = Constants.FALSE;

    public ConditionalSoundInstance(SoundEvent soundIn, SoundSource categoryIn, BlockEntity tile, Supplier<Boolean> condition) {
        super(soundIn, categoryIn);
        this.f_119575_ = (double)tile.m_58899_().m_123341_() + 0.5;
        this.f_119576_ = (double)tile.m_58899_().m_123342_() + 0.5;
        this.f_119577_ = (double)tile.m_58899_().m_123343_() + 0.5;
        this.f_119578_ = true;
        this.condition = condition;
    }

    public ConditionalSoundInstance(SoundEvent soundIn, SoundSource categoryIn, Entity entity, Supplier<Boolean> condition) {
        super(soundIn, categoryIn);
        this.f_119575_ = entity.m_20185_();
        this.f_119576_ = entity.m_20186_();
        this.f_119577_ = entity.m_20189_();
        this.f_119578_ = true;
        this.condition = condition;
    }

    public ConditionalSoundInstance setFadeIn(int fadeIn) {
        this.fadeIn = Math.min(0, fadeIn);
        return this;
    }

    public ConditionalSoundInstance setFadeOut(int fadeOut) {
        this.fadeOut = Math.min(0, fadeOut);
        return this;
    }

    public float getFadeInMultiplier() {
        return this.ticks >= this.fadeIn ? 1.0f : (float)this.ticks / (float)this.fadeIn;
    }

    public float getFadeOutMultiplier() {
        return this.ticks >= this.fadeOut ? 0.0f : (float)(this.fadeOut - this.ticks) / (float)this.fadeOut;
    }

    public void m_7788_() {
        if (!this.beginFadeOut) {
            if (this.ticks < this.fadeIn) {
                ++this.ticks;
            }
            if (!this.condition.get().booleanValue()) {
                this.beginFadeOut = true;
                this.ticks = 0;
            }
        } else {
            ++this.ticks;
        }
        float multiplier = this.beginFadeOut ? this.getFadeOutMultiplier() : this.getFadeInMultiplier();
        this.f_119573_ = this.baseVolume * multiplier;
        if (multiplier <= 0.0f) {
            this.donePlaying = true;
        }
    }

    public boolean m_7801_() {
        return this.donePlaying;
    }
}

