/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.data;

import cofh.lib.util.DeferredRegisterCoFH;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class ItemModelProviderCoFH
extends ItemModelProvider {
    public static final String ARMOR = "armor";
    public static final String MATERIALS = "materials";
    public static final String PROJECTILES = "projectiles";
    public static final String TOOLS = "tools";

    public ItemModelProviderCoFH(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    protected void standardToolSet(DeferredRegisterCoFH<Item> reg, String prefix) {
        this.handheld((Supplier<? extends ItemLike>)reg.getSup(prefix + "_shovel"));
        this.handheld((Supplier<? extends ItemLike>)reg.getSup(prefix + "_pickaxe"));
        this.handheld((Supplier<? extends ItemLike>)reg.getSup(prefix + "_axe"));
        this.handheld((Supplier<? extends ItemLike>)reg.getSup(prefix + "_hoe"));
        this.handheld((Supplier<? extends ItemLike>)reg.getSup(prefix + "_sword"));
    }

    protected void metalSet(DeferredRegisterCoFH<Item> reg, String prefix) {
        this.metalSet(reg, prefix, false);
    }

    protected void metalSet(DeferredRegisterCoFH<Item> reg, String prefix, boolean vanilla) {
        if (!vanilla) {
            this.generated((Supplier<? extends ItemLike>)reg.getSup("raw_" + prefix));
            this.generated((Supplier<? extends ItemLike>)reg.getSup(prefix + "_ingot"));
            this.generated((Supplier<? extends ItemLike>)reg.getSup(prefix + "_nugget"));
        }
        this.generated((Supplier<? extends ItemLike>)reg.getSup(prefix + "_dust"));
        this.generated((Supplier<? extends ItemLike>)reg.getSup(prefix + "_gear"));
    }

    protected void alloySet(DeferredRegisterCoFH<Item> reg, String prefix) {
        this.generated((Supplier<? extends ItemLike>)reg.getSup(prefix + "_ingot"));
        this.generated((Supplier<? extends ItemLike>)reg.getSup(prefix + "_nugget"));
        this.generated((Supplier<? extends ItemLike>)reg.getSup(prefix + "_dust"));
        this.generated((Supplier<? extends ItemLike>)reg.getSup(prefix + "_gear"));
    }

    protected void gemSet(DeferredRegisterCoFH<Item> reg, String prefix) {
        this.gemSet(reg, prefix, false);
    }

    protected void gemSet(DeferredRegisterCoFH<Item> reg, String prefix, boolean vanilla) {
        if (!vanilla) {
            this.generated((Supplier<? extends ItemLike>)reg.getSup(prefix));
        }
        this.generated((Supplier<? extends ItemLike>)reg.getSup(prefix + "_dust"));
        this.generated((Supplier<? extends ItemLike>)reg.getSup(prefix + "_gear"));
    }

    protected String name(Supplier<? extends ItemLike> item) {
        return item.get().m_5456_().getRegistryName().m_135815_();
    }

    protected ResourceLocation itemTexture(Supplier<? extends ItemLike> item) {
        return this.modLoc("item/" + this.name(item));
    }

    protected ResourceLocation itemTexture(Supplier<? extends ItemLike> item, String subfolder) {
        return this.modLoc("item/" + subfolder + "/" + this.name(item));
    }

    protected ItemModelBuilder blockItem(Supplier<? extends Block> block) {
        return this.blockItem(block, "");
    }

    protected ItemModelBuilder blockItem(Supplier<? extends Block> block, String suffix) {
        return (ItemModelBuilder)this.withExistingParent(this.name(block), this.modLoc("block/" + this.name(block) + suffix));
    }

    protected ItemModelBuilder blockWithInventoryModel(Supplier<? extends Block> block) {
        return (ItemModelBuilder)this.withExistingParent(this.name(block), this.modLoc("block/" + this.name(block) + "_inventory"));
    }

    protected ItemModelBuilder blockSprite(Supplier<? extends Block> block) {
        return this.blockSprite(block, this.modLoc("block/" + this.name(block)));
    }

    protected ItemModelBuilder blockSprite(Supplier<? extends Block> block, ResourceLocation texture) {
        return this.generated(() -> ((Block)block.get()).m_5456_(), texture);
    }

    protected ItemModelBuilder generated(Supplier<? extends ItemLike> item, String subfolder) {
        return this.generated(item, this.itemTexture(item, subfolder));
    }

    protected ItemModelBuilder generated(Supplier<? extends ItemLike> item) {
        return this.generated(item, this.itemTexture(item));
    }

    protected ItemModelBuilder generated(Supplier<? extends ItemLike> item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.name(item))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
    }

    protected ItemModelBuilder handheld(Supplier<? extends ItemLike> item) {
        return this.handheld(item, this.itemTexture(item));
    }

    protected ItemModelBuilder handheld(Supplier<? extends ItemLike> item, String subfolder) {
        return this.handheld(item, this.itemTexture(item, subfolder));
    }

    protected ItemModelBuilder handheld(Supplier<? extends ItemLike> item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.name(item), "item/handheld")).texture("layer0", texture);
    }
}

