/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.api.recipe.RecipeContext;
import com.almostreliable.unified.api.recipe.RecipeUnifier;
import com.almostreliable.unified.api.recipe.RecipeUnifierBuilder;
import com.almostreliable.unified.utils.JsonUtils;
import com.almostreliable.unified.utils.Utils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class ImmersiveEngineeringRecipeUnifier
implements RecipeUnifier {
    private static final String BASE_KEY = "base_ingredient";

    @Override
    public void collectUnifier(RecipeUnifierBuilder builder) {
        builder.put("input0", this::createIngredientReplacement);
        builder.put("input1", this::createIngredientReplacement);
        builder.put("input", this::createIngredientReplacement);
        builder.put("additives", this::createIngredientReplacement);
        builder.put("inputs", this::createIngredientReplacement);
        builder.forEachObject("secondaries", (jsonObject, context) -> this.createResultReplacement(jsonObject.get("output"), (RecipeContext)context) instanceof JsonObject ? jsonObject : null);
        builder.put("result", this::createResultReplacement);
        builder.put("results", this::createResultReplacement);
        builder.put("slag", this::createResultReplacement);
    }

    @Nullable
    private JsonElement createResultReplacement(@Nullable JsonElement element, RecipeContext context) {
        JsonArray array;
        if (element instanceof JsonArray && JsonUtils.replaceOn(array = (JsonArray)element, e -> this.createResultReplacement((JsonElement)e, context))) {
            return array;
        }
        if (element instanceof JsonObject) {
            JsonElement baseResult;
            ResourceLocation item;
            JsonObject object = (JsonObject)element;
            JsonElement tag = object.get("tag");
            if (tag != null && (item = context.getPreferredItemForTag(Utils.toItemTag(object.get("tag").getAsString()), $ -> true)) != null) {
                object.remove("tag");
                object.addProperty("item", item.toString());
                return object;
            }
            JsonElement base = object.get(BASE_KEY);
            if (base != null && (baseResult = this.createResultReplacement(base, context)) != null) {
                object.add(BASE_KEY, baseResult);
                return object;
            }
        }
        return context.createResultReplacement(element);
    }

    @Nullable
    private JsonElement createIngredientReplacement(@Nullable JsonElement element, RecipeContext context) {
        JsonObject json;
        if (element instanceof JsonObject && (json = (JsonObject)element).has(BASE_KEY)) {
            return context.createIngredientReplacement(json.get(BASE_KEY));
        }
        return context.createIngredientReplacement(element);
    }
}

