/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import twilightforest.TFSounds;
import twilightforest.block.FireJetBlock;
import twilightforest.block.TFBlocks;
import twilightforest.block.entity.TFBlockEntities;
import twilightforest.client.particle.TFParticleType;
import twilightforest.enums.FireJetVariant;
import twilightforest.util.TFDamageSources;

public class FireJetBlockEntity
extends BlockEntity {
    private int counter = 0;

    public FireJetBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.FLAME_JET.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FireJetBlockEntity te) {
        if (state.m_60734_() == TFBlocks.FIRE_JET.get() || state.m_60734_() == TFBlocks.ENCASED_FIRE_JET.get()) {
            switch ((FireJetVariant)((Object)state.m_61143_(FireJetBlock.STATE))) {
                case POPPING: {
                    FireJetBlockEntity.tickPopping(level, pos, state, te);
                    break;
                }
                case FLAME: {
                    FireJetBlockEntity.tickFlame(level, pos, state, te);
                }
            }
        }
    }

    private static void tickPopping(Level level, BlockPos pos, BlockState state, FireJetBlockEntity te) {
        if (++te.counter >= 80) {
            te.counter = 0;
            if (!level.f_46443_) {
                if (state.m_60734_() == TFBlocks.FIRE_JET.get() || state.m_60734_() == TFBlocks.ENCASED_FIRE_JET.get()) {
                    level.m_46597_(pos, (BlockState)state.m_61124_(FireJetBlock.STATE, (Comparable)((Object)FireJetVariant.FLAME)));
                } else {
                    level.m_7471_(pos, false);
                }
            }
        } else if (te.counter % 20 == 0) {
            for (int i = 0; i < 8; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            }
            level.m_5594_(null, pos, TFSounds.JET_POP, SoundSource.BLOCKS, 0.2f + level.f_46441_.nextFloat() * 0.2f, 0.9f + level.f_46441_.nextFloat() * 0.15f);
        }
    }

    private static void tickFlame(Level level, BlockPos pos, BlockState state, FireJetBlockEntity te) {
        double x = pos.m_123341_();
        double y = pos.m_7494_().m_123342_();
        double z = pos.m_123343_();
        if (++te.counter > 60) {
            te.counter = 0;
            if (!level.f_46443_) {
                if (state.m_60734_() == TFBlocks.FIRE_JET.get() || state.m_60734_() == TFBlocks.ENCASED_FIRE_JET.get()) {
                    level.m_46597_(pos, (BlockState)state.m_61124_(FireJetBlock.STATE, (Comparable)((Object)(state.m_60734_() == TFBlocks.FIRE_JET.get() ? FireJetVariant.IDLE : FireJetVariant.TIMEOUT))));
                } else {
                    level.m_7471_(pos, false);
                }
            }
        }
        if (level.f_46443_) {
            if (te.counter % 2 == 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x + 0.5, y + 1.0, z + 0.5, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)TFParticleType.LARGE_FLAME.get(), x + 0.5, y + 1.0, z + 0.5, 0.0, 0.5, 0.0);
                level.m_7106_((ParticleOptions)TFParticleType.LARGE_FLAME.get(), x - 0.5, y + 1.0, z + 0.5, 0.05, 0.5, 0.0);
                level.m_7106_((ParticleOptions)TFParticleType.LARGE_FLAME.get(), x + 0.5, y + 1.0, z - 0.5, 0.0, 0.5, 0.05);
                level.m_7106_((ParticleOptions)TFParticleType.LARGE_FLAME.get(), x + 1.5, y + 1.0, z + 0.5, -0.05, 0.5, 0.0);
                level.m_7106_((ParticleOptions)TFParticleType.LARGE_FLAME.get(), x + 0.5, y + 1.0, z + 1.5, 0.0, 0.5, -0.05);
            }
            if (te.counter % 4 == 0) {
                level.m_7785_(x + 0.5, y + 0.5, z + 0.5, TFSounds.JET_ACTIVE, SoundSource.BLOCKS, 1.0f + level.f_46441_.nextFloat(), level.f_46441_.nextFloat() * 0.7f + 0.3f, false);
            } else if (te.counter == 1) {
                level.m_7785_(x + 0.5, y + 0.5, z + 0.5, TFSounds.JET_START, SoundSource.BLOCKS, 1.0f + level.f_46441_.nextFloat(), level.f_46441_.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        if (!level.f_46443_ && te.counter % 5 == 0) {
            List entitiesInRange = level.m_45976_(Entity.class, new AABB(pos.m_142082_(-2, 0, -2), pos.m_142082_(2, 4, 2)));
            for (Entity entity : entitiesInRange) {
                if (entity.m_5825_()) continue;
                entity.m_6469_(TFDamageSources.FIRE_JET, 2.0f);
                entity.m_20254_(15);
            }
        }
    }
}

