/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.GhastTrapBlock;
import twilightforest.block.TFBlocks;
import twilightforest.block.TwilightChest;
import twilightforest.client.particle.TFParticleType;
import twilightforest.entity.NoClipMoveHelper;
import twilightforest.entity.TFEntities;
import twilightforest.entity.monster.CarminiteGhastguard;
import twilightforest.entity.monster.CarminiteGhastling;
import twilightforest.entity.projectile.UrGhastFireball;
import twilightforest.loot.TFTreasure;
import twilightforest.util.EntityUtil;
import twilightforest.util.TFDamageSources;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.TFGenerationSettings;

public class UrGhast
extends CarminiteGhastguard {
    private static final EntityDataAccessor<Boolean> DATA_TANTRUM = SynchedEntityData.m_135353_(UrGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int HOVER_ALTITUDE = 20;
    private List<BlockPos> trapLocations;
    private int nextTantrumCry;
    private float damageUntilNextPhase = 10.0f;
    private boolean noTrapMode;
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    private final List<ServerPlayer> hurtBy = new ArrayList<ServerPlayer>();

    public UrGhast(EntityType<? extends UrGhast> type, Level world) {
        super(type, world);
        this.wanderFactor = 32.0f;
        this.f_19794_ = true;
        this.setInTantrum(false);
        this.f_21364_ = 317;
        this.f_21342_ = new NoClipMoveHelper((Mob)this);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return CarminiteGhastguard.registerAttributes().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22277_, 128.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TANTRUM, (Object)false);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.trapLocations = new ArrayList<BlockPos>();
        this.f_21345_.f_25345_.removeIf(e -> e.m_26015_() instanceof CarminiteGhastguard.AIHomedFly);
        this.f_21345_.m_25352_(5, (Goal)new AIWaypointFly(this));
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            if (this.hasHome()) {
                this.f_19853_.m_46597_(this.m_21534_(), ((Block)TFBlocks.UR_GHAST_BOSS_SPAWNER.get()).m_49966_());
            }
            this.m_146870_();
        } else {
            super.m_6043_();
        }
    }

    @Override
    protected SoundEvent m_7515_() {
        return TFSounds.URGHAST_AMBIENT;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return TFSounds.URGHAST_HURT;
    }

    @Override
    protected SoundEvent m_5592_() {
        return TFSounds.URGHAST_DEATH;
    }

    @Override
    public SoundEvent getFireSound() {
        return TFSounds.URGHAST_SHOOT;
    }

    @Override
    public SoundEvent getWarnSound() {
        return TFSounds.URGHAST_WARN;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        } else {
            if (this.isInTantrum()) {
                this.f_19853_.m_7106_((ParticleOptions)TFParticleType.BOSS_TEAR.get(), this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_() * 0.75, this.m_20186_() + this.f_19796_.nextDouble() * (double)this.m_20206_() * 0.5, this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_() * 0.75, 0.0, 0.0, 0.0);
            }
            if (this.f_20919_ > 0) {
                for (int k = 0; k < 5; ++k) {
                    double d = this.f_19796_.nextGaussian() * 0.02;
                    double d1 = this.f_19796_.nextGaussian() * 0.02;
                    double d2 = this.f_19796_.nextGaussian() * 0.02;
                    this.f_19853_.m_7106_((ParticleOptions)(this.f_19796_.nextBoolean() ? ParticleTypes.f_123812_ : ParticleTypes.f_123813_), this.m_20185_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.nextFloat() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d, d1, d2);
                }
            }
        }
    }

    public boolean m_6673_(DamageSource src) {
        return src == DamageSource.f_19310_ || src == DamageSource.f_19305_ || src == DamageSource.f_19307_ || super.m_6673_(src);
    }

    public void m_147240_(double strength, double xRatio, double zRatio) {
    }

    public boolean m_6469_(DamageSource source, float damage) {
        ServerPlayer player;
        if (this.isInTantrum()) {
            damage /= 10.0f;
        }
        float oldHealth = this.m_21223_();
        boolean attackSuccessful = "fireball".equals(source.m_19385_()) && source.m_7639_() instanceof Player ? super.m_6469_(DamageSource.m_19361_((Entity)source.m_7639_(), (Entity)source.m_7640_()), damage) : super.m_6469_(source, damage);
        float lastDamage = oldHealth - this.m_21223_();
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer && !this.hurtBy.contains(player = (ServerPlayer)entity)) {
            this.hurtBy.add(player);
        }
        if (!this.f_19853_.f_46443_) {
            if (this.f_20916_ == this.f_20917_) {
                this.damageUntilNextPhase -= lastDamage;
                TwilightForestMod.LOGGER.debug("Urghast Attack successful, {} damage until phase switch.", (Object)Float.valueOf(this.damageUntilNextPhase));
                if (this.damageUntilNextPhase <= 0.0f) {
                    this.switchPhase();
                }
            } else {
                TwilightForestMod.LOGGER.debug("Urghast Attack fail with {} type attack for {} damage", (Object)source.f_19326_, (Object)Float.valueOf(damage));
            }
        }
        return attackSuccessful;
    }

    private void switchPhase() {
        if (this.isInTantrum()) {
            this.setInTantrum(false);
        } else {
            this.startTantrum();
        }
        this.resetDamageUntilNextPhase();
    }

    public void resetDamageUntilNextPhase() {
        this.damageUntilNextPhase = 18.0f;
    }

    private void startTantrum() {
        this.setInTantrum(true);
        this.spawnGhastsAtTraps();
    }

    private void spawnGhastsAtTraps() {
        ArrayList<BlockPos> ghastSpawns = new ArrayList<BlockPos>(this.trapLocations);
        Collections.shuffle(ghastSpawns);
        int numSpawns = Math.min(2, ghastSpawns.size());
        for (int i = 0; i < numSpawns; ++i) {
            BlockPos spawnCoord = (BlockPos)ghastSpawns.get(i);
            this.spawnMinionGhastsAt(spawnCoord.m_123341_(), spawnCoord.m_123342_(), spawnCoord.m_123343_());
        }
    }

    private void spawnMinionGhastsAt(int x, int y, int z) {
        int tries = 24;
        int spawns = 0;
        int maxSpawns = 6;
        int rangeXZ = 4;
        int rangeY = 8;
        LightningBolt bolt = new LightningBolt(EntityType.f_20465_, this.f_19853_);
        bolt.m_6034_((double)x, (double)(y + 4), (double)z);
        bolt.m_20874_(true);
        this.f_19853_.m_7967_((Entity)bolt);
        for (int i = 0; i < tries; ++i) {
            CarminiteGhastling minion = (CarminiteGhastling)((EntityType)TFEntities.CARMINITE_GHASTLING.get()).m_20615_(this.f_19853_);
            double sx = (double)x + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * (double)rangeXZ;
            double sy = (double)y + this.f_19796_.nextDouble() * (double)rangeY;
            double sz = (double)z + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * (double)rangeXZ;
            minion.m_7678_(sx, sy, sz, this.f_19853_.f_46441_.nextFloat() * 360.0f, 0.0f);
            minion.makeBossMinion();
            if (minion.m_5545_((LevelAccessor)this.f_19853_, MobSpawnType.MOB_SUMMONED)) {
                this.f_19853_.m_7967_((Entity)minion);
                minion.m_21373_();
            }
            if (++spawns >= maxSpawns) break;
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.m_21536_();
        for (CarminiteGhastling ghast : this.f_19853_.m_45976_(CarminiteGhastling.class, this.m_142469_().m_82377_(1.0, 1.0, 1.0))) {
            ghast.m_21373_();
            ghast.m_146870_();
            this.m_5634_(2.0f);
        }
        if (this.trapLocations.isEmpty() && !this.noTrapMode) {
            this.scanForTrapsTwice();
            if (this.trapLocations.isEmpty()) {
                this.noTrapMode = true;
            }
        }
        if (this.isInTantrum()) {
            this.m_6710_(null);
            if (--this.nextTantrumCry <= 0) {
                this.m_5496_(this.m_7975_(null), this.m_6121_(), this.m_6100_());
                this.nextTantrumCry = 20 + this.f_19796_.nextInt(30);
            }
            if (this.f_19797_ % 10 == 0) {
                this.doTantrumDamageEffects();
            }
        }
    }

    private void doTantrumDamageEffects() {
        AABB below = this.m_142469_().m_82386_(0.0, -16.0, 0.0).m_82377_(0.0, 16.0, 0.0);
        for (Player player : this.f_19853_.m_45976_(Player.class, below)) {
            if (!this.f_19853_.m_46861_(player.m_142538_())) continue;
            player.m_6469_(TFDamageSources.GHAST_TEAR, 3.0f);
        }
        for (CarminiteGhastling ghast : this.f_19853_.m_45976_(CarminiteGhastling.class, below)) {
            ghast.m_5997_(0.0, 1.0, 0.0);
        }
    }

    private boolean checkGhastsAtTraps() {
        int trapsWithEnoughGhasts = 0;
        for (BlockPos trap : this.trapLocations) {
            AABB aabb = new AABB(trap, trap.m_142082_(1, 1, 1)).m_82377_(8.0, 16.0, 8.0);
            List nearbyGhasts = this.f_19853_.m_45976_(CarminiteGhastling.class, aabb);
            if (nearbyGhasts.size() < 4) continue;
            ++trapsWithEnoughGhasts;
        }
        return trapsWithEnoughGhasts >= 1;
    }

    @Override
    protected void spitFireball() {
        double offsetX = this.m_5448_().m_20185_() - this.m_20185_();
        double offsetY = this.m_5448_().m_142469_().f_82289_ + (double)(this.m_5448_().m_20206_() / 2.0f) - (this.m_20186_() + (double)(this.m_20206_() / 2.0f));
        double offsetZ = this.m_5448_().m_20189_() - this.m_20189_();
        UrGhastFireball entityFireball = new UrGhastFireball(this.f_19853_, this, offsetX, offsetY, offsetZ, 1);
        double shotSpawnDistance = 8.5;
        Vec3 lookVec = this.m_20252_(1.0f);
        entityFireball.m_6034_(this.m_20185_() + lookVec.f_82479_ * shotSpawnDistance, this.m_20186_() + (double)(this.m_20206_() / 2.0f) + lookVec.f_82480_ * shotSpawnDistance, this.m_20189_() + lookVec.f_82481_ * shotSpawnDistance);
        this.f_19853_.m_7967_((Entity)entityFireball);
        for (int i = 0; i < 2; ++i) {
            entityFireball = new UrGhastFireball(this.f_19853_, this, offsetX + (double)((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 8.0f), offsetY, offsetZ + (double)((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 8.0f), 1);
            entityFireball.m_6034_(this.m_20185_() + lookVec.f_82479_ * shotSpawnDistance, this.m_20186_() + (double)(this.m_20206_() / 2.0f) + lookVec.f_82480_ * shotSpawnDistance, this.m_20189_() + lookVec.f_82481_ * shotSpawnDistance);
            this.f_19853_.m_7967_((Entity)entityFireball);
        }
    }

    private void scanForTrapsTwice() {
        int scanRangeXZ = 48;
        int scanRangeY = 32;
        this.scanForTraps(scanRangeXZ, scanRangeY, this.m_142538_());
        if (this.trapLocations.size() > 0) {
            int ax = 0;
            int ay = 0;
            int az = 0;
            for (BlockPos trapCoords : this.trapLocations) {
                ax += trapCoords.m_123341_();
                ay += trapCoords.m_123342_();
                az += trapCoords.m_123343_();
            }
            this.scanForTraps(scanRangeXZ, scanRangeY, new BlockPos(ax /= this.trapLocations.size(), ay /= this.trapLocations.size(), az /= this.trapLocations.size()));
        }
    }

    private void scanForTraps(int scanRangeXZ, int scanRangeY, BlockPos pos) {
        for (int sx = -scanRangeXZ; sx <= scanRangeXZ; ++sx) {
            for (int sz = -scanRangeXZ; sz <= scanRangeXZ; ++sz) {
                for (int sy = -scanRangeY; sy <= scanRangeY; ++sy) {
                    BlockPos trapCoords = pos.m_142082_(sx, sy, sz);
                    if (!this.isTrapAt(trapCoords)) continue;
                    this.trapLocations.add(trapCoords);
                }
            }
        }
    }

    private boolean isTrapAt(BlockPos pos) {
        BlockState inactive = (BlockState)((GhastTrapBlock)((Object)TFBlocks.GHAST_TRAP.get())).m_49966_().m_61124_((Property)GhastTrapBlock.ACTIVE, (Comparable)Boolean.valueOf(false));
        BlockState active = (BlockState)((GhastTrapBlock)((Object)TFBlocks.GHAST_TRAP.get())).m_49966_().m_61124_((Property)GhastTrapBlock.ACTIVE, (Comparable)Boolean.valueOf(true));
        return this.f_19853_.m_46805_(pos) && (this.f_19853_.m_8055_(pos) == inactive || this.f_19853_.m_8055_(pos) == active);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean isInTantrum() {
        return (Boolean)this.f_19804_.m_135370_(DATA_TANTRUM);
    }

    public void setInTantrum(boolean inTantrum) {
        this.f_19804_.m_135381_(DATA_TANTRUM, (Object)inTantrum);
        this.resetDamageUntilNextPhase();
    }

    @Override
    protected float m_6121_() {
        return 16.0f;
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 0.5f;
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128379_("inTantrum", this.isInTantrum());
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setInTantrum(compound.m_128471_("inTantrum"));
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.f_19853_.f_46443_) {
            TFGenerationSettings.markStructureConquered(this.f_19853_, this.findChestCoords(), TFFeature.DARK_TOWER);
            for (ServerPlayer player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (Entity)this);
            }
            TFTreasure.entityDropsIntoContainer((LivingEntity)this, this.m_7771_(true, cause).m_78975_(LootContextParamSets.f_81415_), ((TwilightChest)((Object)TFBlocks.DARKWOOD_CHEST.get())).m_49966_(), this.findChestCoords());
        }
    }

    protected boolean m_6125_() {
        return false;
    }

    private BlockPos findChestCoords() {
        if (this.trapLocations.size() > 0) {
            int ax = 0;
            int ay = 0;
            int az = 0;
            for (BlockPos trapCoords : this.trapLocations) {
                ax += trapCoords.m_123341_();
                ay += trapCoords.m_123342_();
                az += trapCoords.m_123343_();
            }
            return new BlockPos(ax /= this.trapLocations.size(), (ay /= this.trapLocations.size()) + 2, az /= this.trapLocations.size());
        }
        return EntityUtil.bossChestLocation((Mob)this);
    }

    @Override
    protected boolean shouldAttack(LivingEntity living) {
        return !this.isInTantrum();
    }

    @Override
    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    static class AIWaypointFly
    extends Goal {
        private final UrGhast taskOwner;
        private final List<BlockPos> pointsToVisit;
        private int currentPoint = 0;

        AIWaypointFly(UrGhast ghast) {
            this.taskOwner = ghast;
            this.pointsToVisit = this.createPath();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl entitymovehelper = this.taskOwner.m_21566_();
            if (!entitymovehelper.m_24995_()) {
                return true;
            }
            double d0 = entitymovehelper.m_25000_() - this.taskOwner.m_20185_();
            double d3 = d0 * d0 + (d1 = entitymovehelper.m_25001_() - this.taskOwner.m_20186_()) * d1 + (d2 = entitymovehelper.m_25002_() - this.taskOwner.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            if (this.pointsToVisit.isEmpty()) {
                this.pointsToVisit.addAll(this.createPath());
            } else {
                if (this.currentPoint >= this.pointsToVisit.size()) {
                    this.currentPoint = 0;
                    if (!this.taskOwner.checkGhastsAtTraps()) {
                        this.taskOwner.spawnGhastsAtTraps();
                    }
                }
                double x = this.pointsToVisit.get(this.currentPoint).m_123341_();
                double y = this.pointsToVisit.get(this.currentPoint).m_123342_() + 20;
                double z = this.pointsToVisit.get(this.currentPoint).m_123343_();
                this.taskOwner.m_21566_().m_6849_(x, y, z, 1.0);
                ++this.currentPoint;
                this.taskOwner.f_19794_ = false;
            }
        }

        private List<BlockPos> createPath() {
            ArrayList<BlockPos> potentialPoints = new ArrayList<BlockPos>();
            BlockPos pos = new BlockPos((Vec3i)this.taskOwner.m_142538_());
            if (!this.taskOwner.noTrapMode) {
                potentialPoints.addAll(this.taskOwner.trapLocations);
            } else {
                potentialPoints.add(pos.m_142082_(20, -20, 0));
                potentialPoints.add(pos.m_142082_(0, -20, -20));
                potentialPoints.add(pos.m_142082_(-20, -20, 0));
                potentialPoints.add(pos.m_142082_(0, -20, 20));
            }
            Collections.shuffle(potentialPoints);
            if (this.taskOwner.noTrapMode) {
                potentialPoints.add(pos.m_6625_(20));
            }
            return potentialPoints;
        }
    }
}

