/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.block.TFPortalBlock;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.registration.TFGenerationSettings;

public class TFTeleporter
implements ITeleporter {
    private static final Map<ResourceLocation, Map<ColumnPos, PortalPosition>> destinationCoordinateCache = new HashMap<ResourceLocation, Map<ColumnPos, PortalPosition>>();
    private static final Object2LongMap<ColumnPos> columnMap = new Object2LongOpenHashMap();
    private static boolean locked;

    public TFTeleporter(boolean locked) {
        TFTeleporter.locked = locked;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel dest, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        PortalInfo pos = TFTeleporter.placeInExistingPortal(dest, entity, entity.m_142538_(), entity instanceof Player);
        if (pos == null) {
            pos = TFTeleporter.moveToSafeCoords(dest, entity);
            this.makePortal(entity, dest, pos.f_77676_);
            pos = TFTeleporter.placeInExistingPortal(dest, entity, new BlockPos(pos.f_77676_), entity instanceof Player);
        }
        return pos;
    }

    @Nullable
    private static PortalInfo placeInExistingPortal(ServerLevel world, Entity entity, BlockPos pos, boolean isPlayer) {
        PortalPosition portalPosition;
        int i = 200;
        boolean flag = true;
        BlockPos blockpos = BlockPos.f_121853_;
        ColumnPos columnPos = new ColumnPos(pos);
        if (!isPlayer && columnMap.containsKey((Object)columnPos)) {
            return null;
        }
        PortalPosition portalPosition2 = portalPosition = destinationCoordinateCache.containsKey(world.m_46472_().m_135782_()) ? destinationCoordinateCache.get(world.m_46472_().m_135782_()).get(columnPos) : null;
        if (portalPosition != null) {
            blockpos = portalPosition.pos;
            portalPosition.lastUpdateTime = world.m_46467_();
            flag = false;
        } else {
            double d0 = Double.MAX_VALUE;
            for (int i1 = -i; i1 <= i; ++i1) {
                for (int j1 = -i; j1 <= i; ++j1) {
                    ChunkPos chunkPos;
                    if (!world.m_6857_().m_61937_(pos.m_142082_(i1, 0, j1)) || !world.m_7726_().f_8325_.m_140425_(chunkPos = new ChunkPos(pos.m_142082_(i1, 0, j1)))) continue;
                    LevelChunk chunk = world.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
                    BlockPos blockpos1 = pos.m_142082_(i1, TFTeleporter.getScanHeight(world, pos) - pos.m_123342_(), j1);
                    while (blockpos1.m_123342_() >= 0) {
                        BlockPos blockpos2 = blockpos1.m_7495_();
                        if (!(d0 >= 0.0 && blockpos1.m_123331_((Vec3i)pos) >= d0 || !TFTeleporter.isPortal(chunk.m_8055_(blockpos1)))) {
                            blockpos2 = blockpos1.m_7495_();
                            while (TFTeleporter.isPortal(chunk.m_8055_(blockpos2))) {
                                blockpos1 = blockpos2;
                                blockpos2 = blockpos2.m_7495_();
                            }
                            float d1 = (float)blockpos1.m_123331_((Vec3i)pos);
                            if (d0 < 0.0 || (double)d1 < d0) {
                                d0 = d1;
                                blockpos = blockpos1;
                                i = Mth.m_14167_((float)Mth.m_14116_((float)d1));
                            }
                        }
                        blockpos1 = blockpos2;
                    }
                }
            }
        }
        if (blockpos.equals((Object)BlockPos.f_121853_)) {
            long factor = world.m_46467_() + 300L;
            columnMap.put((Object)columnPos, factor);
            return null;
        }
        if (flag) {
            destinationCoordinateCache.putIfAbsent(world.m_46472_().m_135782_(), Maps.newHashMapWithExpectedSize((int)4096));
            destinationCoordinateCache.get(world.m_46472_().m_135782_()).put(columnPos, new PortalPosition(blockpos, world.m_46467_()));
            world.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)new BlockPos(columnPos.f_140723_, blockpos.m_123342_(), columnPos.f_140724_));
        }
        BlockPos[] portalBorder = TFTeleporter.getBoundaryPositions(world, blockpos).toArray(new BlockPos[0]);
        BlockPos borderPos = portalBorder[0];
        double portalX = (double)borderPos.m_123341_() + 0.5;
        double portalY = (double)borderPos.m_123342_() + 1.0;
        double portalZ = (double)borderPos.m_123343_() + 0.5;
        return TFTeleporter.makePortalInfo(entity, portalX, portalY, portalZ);
    }

    private static int getScanHeight(ServerLevel world, BlockPos pos) {
        return TFTeleporter.getScanHeight(world, pos.m_123341_(), pos.m_123343_());
    }

    private static int getScanHeight(ServerLevel world, int x, int z) {
        int worldHeight = world.m_151558_() - 1;
        int chunkHeight = world.m_6325_(x >> 4, z >> 4).m_62098_() + 15;
        return Math.min(worldHeight, chunkHeight);
    }

    private static boolean isPortal(BlockState state) {
        return state.m_60734_() == TFBlocks.TWILIGHT_PORTAL.get();
    }

    private static Set<BlockPos> getBoundaryPositions(ServerLevel world, BlockPos start) {
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        checked.add(start);
        TFTeleporter.checkAdjacent(world, start, checked, result);
        return result;
    }

    private static void checkAdjacent(ServerLevel world, BlockPos pos, Set<BlockPos> checked, Set<BlockPos> result) {
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            BlockPos offset = pos.m_142300_(facing);
            if (!checked.add(offset)) continue;
            if (TFTeleporter.isPortalAt(world, offset)) {
                TFTeleporter.checkAdjacent(world, offset, checked, result);
                continue;
            }
            result.add(offset);
        }
    }

    private static boolean isPortalAt(ServerLevel world, BlockPos pos) {
        return TFTeleporter.isPortal(world.m_8055_(pos));
    }

    private static PortalInfo moveToSafeCoords(ServerLevel world, Entity entity) {
        boolean checkProgression = TFGenerationSettings.isProgressionEnforced((Level)world);
        BlockPos pos = entity.m_142538_();
        if (TFTeleporter.isSafeAround((Level)world, pos, entity, checkProgression)) {
            TwilightForestMod.LOGGER.debug("Portal destination looks safe!");
            return TFTeleporter.makePortalInfo(entity, entity.m_20182_());
        }
        TwilightForestMod.LOGGER.debug("Portal destination looks unsafe, rerouting!");
        BlockPos safeCoords = TFTeleporter.findSafeCoords(world, 200, pos, entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.debug("Safely rerouted!");
            return TFTeleporter.makePortalInfo(entity, safeCoords.m_123341_(), entity.m_20186_(), safeCoords.m_123343_());
        }
        TwilightForestMod.LOGGER.info("Did not find a safe portal spot at first try, trying again with longer range.");
        safeCoords = TFTeleporter.findSafeCoords(world, 400, pos, entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.info("Safely rerouted to long range portal.  Return trip not guaranteed.");
            return TFTeleporter.makePortalInfo(entity, safeCoords.m_123341_(), entity.m_20186_(), safeCoords.m_123343_());
        }
        TwilightForestMod.LOGGER.warn("Still did not find a safe portal spot.");
        return TFTeleporter.makePortalInfo(entity, entity.m_20182_());
    }

    public static boolean isSafeAround(Level world, BlockPos pos, Entity entity, boolean checkProgression) {
        if (!TFTeleporter.isSafe(world, pos, entity, checkProgression)) {
            return false;
        }
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            if (TFTeleporter.isSafe(world, pos.m_5484_(facing, 16), entity, checkProgression)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSafe(Level world, BlockPos pos, Entity entity, boolean checkProgression) {
        return TFTeleporter.checkPos(world, pos) && (!checkProgression || TFTeleporter.checkBiome(world, pos, entity)) && TFTeleporter.checkStructure(world, pos);
    }

    private static boolean checkPos(Level world, BlockPos pos) {
        return world.m_6857_().m_61937_(pos);
    }

    private static boolean checkStructure(Level world, BlockPos pos) {
        ChunkGeneratorTwilight generator = WorldUtil.getChunkGenerator((LevelAccessor)world);
        if (generator != null) {
            return !TFGenerationSettings.locateTFStructureInRange((WorldGenLevel)((ServerLevel)world), pos, 0).isPresent();
        }
        return true;
    }

    private static boolean checkBiome(Level world, BlockPos pos, Entity entity) {
        return TFGenerationSettings.isBiomeSafeFor((Biome)world.m_204166_(pos).m_203334_(), entity);
    }

    @Nullable
    private static BlockPos findSafeCoords(ServerLevel world, int range, BlockPos pos, Entity entity, boolean checkProgression) {
        int attempts = range / 8;
        for (int x = 0; x < attempts; ++x) {
            for (int z = 0; z < attempts; ++z) {
                BlockPos dPos = new BlockPos(pos.m_123341_() + x * attempts - range / 2, 100, pos.m_123343_() + z * attempts - range / 2);
                if (!TFTeleporter.isSafeAround((Level)world, dPos, entity, checkProgression)) continue;
                return dPos;
            }
        }
        return null;
    }

    private void makePortal(Entity entity, ServerLevel world, Vec3 pos) {
        TFTeleporter.loadSurroundingArea(world, pos);
        BlockPos spot = TFTeleporter.findPortalCoords(world, pos, blockPos -> TFTeleporter.isPortalAt(world, blockPos));
        String name = entity.m_7755_().getString();
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found existing portal for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cachePortalCoords(world, pos, spot);
            return;
        }
        spot = TFTeleporter.findPortalCoords(world, pos, blockpos -> TFTeleporter.isIdealForPortal(world, blockpos));
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found ideal portal spot for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cachePortalCoords(world, pos, this.makePortalAt((Level)world, spot));
            return;
        }
        TwilightForestMod.LOGGER.debug("Did not find ideal portal spot, shooting for okay one for {}", (Object)name);
        spot = TFTeleporter.findPortalCoords(world, pos, blockPos -> TFTeleporter.isOkayForPortal(world, blockPos));
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found okay portal spot for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cachePortalCoords(world, pos, this.makePortalAt((Level)world, spot));
            return;
        }
        TwilightForestMod.LOGGER.debug("Did not even find an okay portal spot, just making a random one for {}", (Object)name);
        double yFactor = TFTeleporter.getYFactor(world);
        TFTeleporter.cachePortalCoords(world, pos, this.makePortalAt((Level)world, new BlockPos(entity.m_20185_(), entity.m_20186_() * yFactor - 1.0, entity.m_20189_())));
    }

    private static void loadSurroundingArea(ServerLevel world, Vec3 pos) {
        int x = Mth.m_14107_((double)pos.f_82479_) >> 4;
        int z = Mth.m_14107_((double)pos.f_82480_) >> 4;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                world.m_6325_(x + dx, z + dz);
            }
        }
    }

    @Nullable
    private static BlockPos findPortalCoords(ServerLevel world, Vec3 loc, Predicate<BlockPos> predicate) {
        double yFactor = TFTeleporter.getYFactor(world);
        int entityX = Mth.m_14107_((double)loc.f_82479_);
        int entityZ = Mth.m_14107_((double)loc.f_82481_);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        double spotWeight = -1.0;
        BlockPos spot = null;
        int range = 16;
        for (int rx = entityX - range; rx <= entityX + range; ++rx) {
            double xWeight = (double)rx + 0.5 - loc.f_82479_;
            for (int rz = entityZ - range; rz <= entityZ + range; ++rz) {
                double zWeight = (double)rz + 0.5 - loc.f_82481_;
                for (int ry = TFTeleporter.getScanHeight(world, rx, rz); ry >= world.m_141937_(); --ry) {
                    if (!world.m_46859_((BlockPos)pos.m_122178_(rx, ry, rz))) continue;
                    while (ry > world.m_141937_() && world.m_46859_((BlockPos)pos.m_122178_(rx, ry - 1, rz))) {
                        --ry;
                    }
                    double yWeight = (double)ry + 0.5 - loc.f_82480_ * yFactor;
                    double rPosWeight = xWeight * xWeight + yWeight * yWeight + zWeight * zWeight;
                    if (!(spotWeight < 0.0) && !(rPosWeight < spotWeight) || !predicate.test((BlockPos)pos)) continue;
                    spotWeight = rPosWeight;
                    spot = pos.m_7949_();
                }
            }
        }
        return spot;
    }

    private static double getYFactor(ServerLevel world) {
        return world.m_46472_().m_135782_().equals((Object)Level.f_46428_.m_135782_()) ? 2.0 : 0.5;
    }

    private static void cachePortalCoords(ServerLevel world, Vec3 loc, BlockPos pos) {
        int x = Mth.m_14107_((double)loc.f_82479_);
        int z = Mth.m_14107_((double)loc.f_82481_);
        destinationCoordinateCache.putIfAbsent(world.m_46472_().m_135782_(), Maps.newHashMapWithExpectedSize((int)4096));
        destinationCoordinateCache.get(world.m_46472_().m_135782_()).put(new ColumnPos(x, z), new PortalPosition(pos, world.m_46467_()));
    }

    private static boolean isIdealForPortal(ServerLevel world, BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 4; ++potentialY) {
                    BlockPos tPos = pos.m_142082_(potentialX - 1, potentialY, potentialZ - 1);
                    Material material = world.m_8055_(tPos).m_60767_();
                    if ((potentialY != 0 || material == Material.f_76315_) && (potentialY < 1 || material.m_76336_())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected BlockPos makePortalAt(Level world, BlockPos pos) {
        BlockState grass = Blocks.f_50440_.m_49966_();
        world.m_46597_(pos.m_142125_().m_142127_(), grass);
        world.m_46597_(pos.m_142127_(), grass);
        world.m_46597_(pos.m_142126_().m_142127_(), grass);
        world.m_46597_(pos.m_142385_(2).m_142127_(), grass);
        world.m_46597_(pos.m_142125_(), grass);
        world.m_46597_(pos.m_142385_(2), grass);
        world.m_46597_(pos.m_142125_().m_142128_(), grass);
        world.m_46597_(pos.m_142385_(2).m_142128_(), grass);
        world.m_46597_(pos.m_142125_().m_142383_(2), grass);
        world.m_46597_(pos.m_142383_(2), grass);
        world.m_46597_(pos.m_142126_().m_142383_(2), grass);
        world.m_46597_(pos.m_142385_(2).m_142383_(2), grass);
        BlockState dirt = Blocks.f_50493_.m_49966_();
        world.m_46597_(pos.m_7495_(), dirt);
        world.m_46597_(pos.m_142126_().m_7495_(), dirt);
        world.m_46597_(pos.m_142128_().m_7495_(), dirt);
        world.m_46597_(pos.m_142126_().m_142128_().m_7495_(), dirt);
        BlockState portal = (BlockState)((TFPortalBlock)((Object)TFBlocks.TWILIGHT_PORTAL.get())).m_49966_().m_61124_((Property)TFPortalBlock.DISALLOW_RETURN, (Comparable)Boolean.valueOf(locked || (Boolean)TFConfig.COMMON_CONFIG.shouldReturnPortalBeUsable.get() == false));
        world.m_7731_(pos, portal, 2);
        world.m_7731_(pos.m_142126_(), portal, 2);
        world.m_7731_(pos.m_142128_(), portal, 2);
        world.m_7731_(pos.m_142126_().m_142128_(), portal, 2);
        for (int dx = -1; dx <= 2; ++dx) {
            for (int dz = -1; dz <= 2; ++dz) {
                for (int dy = 1; dy <= 5; ++dy) {
                    world.m_7471_(pos.m_142082_(dx, dy, dz), false);
                }
            }
        }
        world.m_7731_(pos.m_142125_().m_142127_().m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_142127_().m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_142126_().m_142127_().m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_142385_(2).m_142127_().m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_142125_().m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_142385_(2).m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_142125_().m_142128_().m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_142385_(2).m_142128_().m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_142125_().m_142383_(2).m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_142383_(2).m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_142126_().m_142383_(2).m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        world.m_7731_(pos.m_142385_(2).m_142383_(2).m_7494_(), TFTeleporter.randNatureBlock(world.f_46441_), 2);
        return pos;
    }

    private static BlockState randNatureBlock(Random random) {
        Block[] blocks = new Block[]{Blocks.f_50072_, Blocks.f_50073_, Blocks.f_50034_, Blocks.f_50112_, Blocks.f_50111_};
        return blocks[random.nextInt(blocks.length)].m_49966_();
    }

    private static boolean isOkayForPortal(ServerLevel world, BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 4; ++potentialY) {
                    BlockPos tPos = pos.m_142082_(potentialX - 1, potentialY, potentialZ - 1);
                    Material material = world.m_8055_(tPos).m_60767_();
                    if ((potentialY != 0 || material.m_76333_() || material.m_76332_()) && (potentialY < 1 || material.m_76336_())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static PortalInfo makePortalInfo(Entity entity, double x, double y, double z) {
        return TFTeleporter.makePortalInfo(entity, new Vec3(x, y, z));
    }

    private static PortalInfo makePortalInfo(Entity entity, Vec3 pos) {
        return new PortalInfo(pos, Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
    }

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        entity.f_19789_ = 0.0f;
        return repositionEntity.apply(false);
    }

    static class PortalPosition {
        public final BlockPos pos;
        long lastUpdateTime;

        PortalPosition(BlockPos pos, long time) {
            this.pos = pos;
            this.lastUpdateTime = time;
        }
    }
}

