/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import twilightforest.block.TFBlocks;

public class TFGenDarkCanopyTree
extends Feature<TreeConfiguration> {
    int difference = 0;
    BlockPos validPos = new BlockPos(0, 0, 0);

    public TFGenDarkCanopyTree(Codec<TreeConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfiguration> ctx) {
        WorldGenLevel reader = ctx.m_159774_();
        BlockPos pos = ctx.m_159777_();
        Random rand = ctx.m_159776_();
        TreeConfiguration config = (TreeConfiguration)ctx.m_159778_();
        boolean foundDirt = false;
        for (int dy = pos.m_123342_(); dy >= reader.m_141937_(); --dy) {
            Material materialUnder = reader.m_8055_(new BlockPos(pos.m_123341_(), dy - 1, pos.m_123343_())).m_60767_();
            if (materialUnder == Material.f_76315_ || materialUnder == Material.f_76314_) {
                foundDirt = true;
                this.validPos = pos = new BlockPos(pos.m_123341_(), dy, pos.m_123343_());
                break;
            }
            if (materialUnder == Material.f_76278_ || materialUnder == Material.f_76317_) break;
        }
        if (!foundDirt) {
            return false;
        }
        for (Direction e : Direction.Plane.HORIZONTAL) {
            if (reader.m_8055_(pos.m_142300_(e)).m_60767_() != Material.f_76320_) continue;
            return false;
        }
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BoundingBox mutableboundingbox = BoundingBox.m_71044_();
        BiConsumer<BlockPos, BlockState> biConsumer = (p_160555_, p_160556_) -> {
            set1.add(p_160555_.m_7949_());
            reader.m_7731_(p_160555_, p_160556_, 19);
        };
        BiConsumer<BlockPos, BlockState> biConsumer1 = (p_160548_, p_160549_) -> {
            set2.add(p_160548_.m_7949_());
            reader.m_7731_(p_160548_, p_160549_, 19);
        };
        BiConsumer<BlockPos, BlockState> biConsumer2 = (p_160543_, p_160544_) -> {
            set3.add(p_160543_.m_7949_());
            reader.m_7731_(p_160543_, p_160544_, 19);
        };
        boolean flag = this.doPlace(reader, rand, pos, biConsumer, biConsumer1, config);
        this.difference = mutableboundingbox.m_162396_() - pos.m_123342_();
        mutableboundingbox.m_162367_(0, pos.m_123342_(), 0);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!config.f_68187_.isEmpty()) {
                ArrayList list1 = Lists.newArrayList((Iterable)set1);
                ArrayList list2 = Lists.newArrayList((Iterable)set2);
                list1.sort(Comparator.comparingInt(Vec3i::m_123342_));
                list2.sort(Comparator.comparingInt(Vec3i::m_123342_));
                config.f_68187_.forEach(p_160528_ -> p_160528_.m_142741_((LevelSimulatedReader)reader, biConsumer2, rand, list1, list2));
            }
            return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)set1, (Iterable)set2, (Iterable)set3)).map(p_160521_ -> {
                DiscreteVoxelShape shape = TFGenDarkCanopyTree.updateLeaves((LevelAccessor)reader, p_160521_, set1, set3);
                StructureTemplate.m_74510_((LevelAccessor)reader, (int)3, (DiscreteVoxelShape)shape, (int)p_160521_.m_162395_(), (int)p_160521_.m_162396_(), (int)p_160521_.m_162398_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private boolean doPlace(WorldGenLevel level, Random p_160512_, BlockPos pos, BiConsumer<BlockPos, BlockState> consumer1, BiConsumer<BlockPos, BlockState> consumer2, TreeConfiguration config) {
        int i = config.f_68190_.m_70309_(p_160512_);
        int j = config.f_68189_.m_5969_(p_160512_, i, config);
        int k = i - j;
        int l = config.f_68189_.m_5937_(p_160512_, k);
        if ((pos = new BlockPos(pos.m_123341_(), this.validPos.m_123342_(), pos.m_123343_())).m_123342_() >= level.m_141937_() + 1 && pos.m_123342_() + i + 1 <= level.m_151558_()) {
            if (!((SaplingBlock)TFBlocks.DARKWOOD_SAPLING.get()).m_7898_(level.m_8055_(pos), (LevelReader)level, pos)) {
                return false;
            }
            OptionalInt optionalint = config.f_68191_.m_68295_();
            int i1 = this.getMaxFreeTreeHeight((LevelSimulatedReader)level, i, pos, config);
            if (i1 >= i || optionalint.isPresent() && i1 >= optionalint.getAsInt()) {
                List list = config.f_68190_.m_142625_((LevelSimulatedReader)level, consumer1, p_160512_, i1, pos, config);
                list.forEach(p_160539_ -> config.f_68189_.m_161413_((LevelSimulatedReader)level, consumer2, p_160512_, config, i1, p_160539_, j, l));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader level, int trunkHeight, BlockPos pos, TreeConfiguration config) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= trunkHeight + 1; ++i) {
            int j = config.f_68191_.m_6133_(trunkHeight, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    mutable.m_122154_((Vec3i)pos, k, i, l);
                    if (TFGenDarkCanopyTree.isFree(level, (BlockPos)mutable) && config.f_68193_) continue;
                    return i - 2;
                }
            }
        }
        return trunkHeight;
    }

    protected void m_5974_(LevelWriter world, BlockPos pos, BlockState state) {
        TFGenDarkCanopyTree.setBlockKnownShape(world, pos, state);
    }

    public static void setBlockKnownShape(LevelWriter p_236408_0_, BlockPos p_236408_1_, BlockState p_236408_2_) {
        p_236408_0_.m_7731_(p_236408_1_, p_236408_2_, 19);
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor p_67203_, BoundingBox p_67204_, Set<BlockPos> p_67205_, Set<BlockPos> p_67206_) {
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(p_67204_.m_71056_(), p_67204_.m_71057_(), p_67204_.m_71058_());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : Lists.newArrayList(p_67206_)) {
            if (!p_67204_.m_71051_((Vec3i)blockpos)) continue;
            discretevoxelshape.m_142703_(blockpos.m_123341_() - p_67204_.m_162395_(), blockpos.m_123342_() - p_67204_.m_162396_(), blockpos.m_123343_() - p_67204_.m_162398_());
        }
        for (BlockPos blockpos1 : Lists.newArrayList(p_67205_)) {
            if (p_67204_.m_71051_((Vec3i)blockpos1)) {
                discretevoxelshape.m_142703_(blockpos1.m_123341_() - p_67204_.m_162395_(), blockpos1.m_123342_() - p_67204_.m_162396_(), blockpos1.m_123343_() - p_67204_.m_162398_());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutableblockpos.m_122159_((Vec3i)blockpos1, direction);
                if (p_67205_.contains(blockpos$mutableblockpos) || !(blockstate = p_67203_.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)list.get(0)).add(blockpos$mutableblockpos.m_7949_());
                TFGenDarkCanopyTree.setBlockKnownShape((LevelWriter)p_67203_, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
                if (!p_67204_.m_71051_((Vec3i)blockpos$mutableblockpos)) continue;
                discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - p_67204_.m_162395_(), blockpos$mutableblockpos.m_123342_() - p_67204_.m_162396_(), blockpos$mutableblockpos.m_123343_() - p_67204_.m_162398_());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (p_67204_.m_71051_((Vec3i)blockpos2)) {
                    discretevoxelshape.m_142703_(blockpos2.m_123341_() - p_67204_.m_162395_(), blockpos2.m_123342_() - p_67204_.m_162396_(), blockpos2.m_123343_() - p_67204_.m_162398_());
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutableblockpos.m_122159_((Vec3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutableblockpos) || set1.contains(blockpos$mutableblockpos) || !(blockstate1 = p_67203_.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_) || (k = ((Integer)blockstate1.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(l + 1));
                    TFGenDarkCanopyTree.setBlockKnownShape((LevelWriter)p_67203_, (BlockPos)blockpos$mutableblockpos, blockstate2);
                    if (p_67204_.m_71051_((Vec3i)blockpos$mutableblockpos)) {
                        discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - p_67204_.m_162395_(), blockpos$mutableblockpos.m_123342_() - p_67204_.m_162396_(), blockpos$mutableblockpos.m_123343_() - p_67204_.m_162398_());
                    }
                    set1.add(blockpos$mutableblockpos.m_7949_());
                }
            }
        }
        return discretevoxelshape;
    }

    public static boolean isFree(LevelSimulatedReader pLevel, BlockPos pPos) {
        return TFGenDarkCanopyTree.validTreePos(pLevel, pPos) || pLevel.m_7433_(pPos, p_67281_ -> p_67281_.m_204336_(BlockTags.f_13106_));
    }

    private static boolean isBlockWater(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, p_67271_ -> p_67271_.m_60713_(Blocks.f_49990_));
    }

    public static boolean isAirOrLeaves(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, p_67266_ -> p_67266_.m_60795_() || p_67266_.m_204336_(BlockTags.f_13035_) || p_67266_.m_60713_((Block)TFBlocks.HARDENED_DARK_LEAVES.get()));
    }

    private static boolean isReplaceablePlant(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, p_160551_ -> {
            Material material = p_160551_.m_60767_();
            return material == Material.f_76302_;
        });
    }

    public static boolean validTreePos(LevelSimulatedReader pLevel, BlockPos pPos) {
        return TFGenDarkCanopyTree.isAirOrLeaves(pLevel, pPos) || TFGenDarkCanopyTree.isReplaceablePlant(pLevel, pPos) || TFGenDarkCanopyTree.isBlockWater(pLevel, pPos);
    }
}

