/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingManager;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.block.CraftingMonitorBlock;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.craftingmonitor.CraftingMonitorBlockEntity;
import com.refinedmods.refinedstorage.blockentity.craftingmonitor.ICraftingMonitor;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationManager;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CraftingMonitorNetworkNode
extends NetworkNode
implements ICraftingMonitor {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "crafting_monitor");
    private static final String NBT_TAB_SELECTED = "TabSelected";
    private static final String NBT_TAB_PAGE = "TabPage";
    private Optional<UUID> tabSelected = Optional.empty();
    private int tabPage;

    public CraftingMonitorNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getCraftingMonitor().getUsage();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Component getTitle() {
        return new TranslatableComponent("gui.refinedstorage.crafting_monitor");
    }

    @Override
    public void onCancelled(ServerPlayer player, @Nullable UUID id) {
        if (this.network != null) {
            this.network.getItemGridHandler().onCraftingCancelRequested(player, id);
        }
    }

    @Override
    public BlockEntitySynchronizationParameter<Integer, ?> getRedstoneModeParameter() {
        return NetworkNodeBlockEntity.REDSTONE_MODE;
    }

    @Override
    public Collection<ICraftingTask> getTasks() {
        return this.network != null ? this.network.getCraftingManager().getTasks() : Collections.emptyList();
    }

    @Override
    @Nullable
    public ICraftingManager getCraftingManager() {
        return this.network != null ? this.network.getCraftingManager() : null;
    }

    @Override
    public boolean isActiveOnClient() {
        BlockState state = this.level.m_8055_(this.pos);
        if (state.m_60734_() instanceof CraftingMonitorBlock) {
            return (Boolean)state.m_61143_((Property)NetworkNodeBlock.CONNECTED);
        }
        return false;
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        tag.m_128405_(NBT_TAB_PAGE, this.tabPage);
        this.tabSelected.ifPresent(uuid -> tag.m_128362_(NBT_TAB_SELECTED, uuid));
        return tag;
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        if (tag.m_128441_(NBT_TAB_PAGE)) {
            this.tabPage = tag.m_128451_(NBT_TAB_PAGE);
        }
        if (tag.m_128403_(NBT_TAB_SELECTED)) {
            this.tabSelected = Optional.of(tag.m_128342_(NBT_TAB_SELECTED));
        }
    }

    @Override
    public void onClosed(Player player) {
    }

    @Override
    public Optional<UUID> getTabSelected() {
        return this.level.f_46443_ ? CraftingMonitorBlockEntity.TAB_SELECTED.getValue() : this.tabSelected;
    }

    public void setTabSelected(Optional<UUID> tabSelected) {
        this.tabSelected = tabSelected;
    }

    @Override
    public int getTabPage() {
        return this.level.f_46443_ ? CraftingMonitorBlockEntity.TAB_PAGE.getValue() : this.tabPage;
    }

    public void setTabPage(int tabPage) {
        this.tabPage = tabPage;
    }

    @Override
    public void onTabSelectionChanged(Optional<UUID> tab) {
        BlockEntitySynchronizationManager.setParameter(CraftingMonitorBlockEntity.TAB_SELECTED, tab);
    }

    @Override
    public void onTabPageChanged(int page) {
        if (page >= 0) {
            BlockEntitySynchronizationManager.setParameter(CraftingMonitorBlockEntity.TAB_PAGE, page);
        }
    }

    @Override
    public int getSlotId() {
        return -1;
    }
}

