/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.tracker;

import com.refinedmods.refinedstorage.api.storage.tracker.IStorageTracker;
import com.refinedmods.refinedstorage.api.storage.tracker.StorageTrackerEntry;
import com.refinedmods.refinedstorage.util.ItemStackKey;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemStorageTracker
implements IStorageTracker<ItemStack> {
    private static final String NBT_STACK = "Stack";
    private static final String NBT_NAME = "Name";
    private static final String NBT_TIME = "Time";
    private final Map<ItemStackKey, StorageTrackerEntry> changes = new HashMap<ItemStackKey, StorageTrackerEntry>();
    private final Runnable listener;

    public ItemStorageTracker(Runnable listener) {
        this.listener = listener;
    }

    @Override
    public void changed(Player player, ItemStack stack) {
        this.changes.put(new ItemStackKey(stack), new StorageTrackerEntry(System.currentTimeMillis(), player.m_7755_().getString()));
        this.listener.run();
    }

    @Override
    public StorageTrackerEntry get(ItemStack stack) {
        return this.changes.get(new ItemStackKey(stack));
    }

    @Override
    public void readFromNbt(ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            ItemStack stack = StackUtils.deserializeStackFromNbt(tag.m_128469_(NBT_STACK));
            if (stack.m_41619_()) continue;
            this.changes.put(new ItemStackKey(stack), new StorageTrackerEntry(tag.m_128454_(NBT_TIME), tag.m_128461_(NBT_NAME)));
        }
    }

    @Override
    public ListTag serializeNbt() {
        ListTag list = new ListTag();
        for (Map.Entry<ItemStackKey, StorageTrackerEntry> entry : this.changes.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_(NBT_TIME, entry.getValue().getTime());
            tag.m_128359_(NBT_NAME, entry.getValue().getName());
            tag.m_128365_(NBT_STACK, (Tag)StackUtils.serializeStackToNbt(entry.getKey().getStack()));
            list.add((Object)tag);
        }
        return list;
    }
}

