/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting.builders;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import blusunrize.immersiveengineering.api.energy.ThermoelectricSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public class ThermoelectricSourceBuilder
extends IEFinishedRecipe<ThermoelectricSourceBuilder> {
    public static final String SINGLE_BLOCK_KEY = "singleBlock";
    public static final String BLOCK_TAG_KEY = "blockTag";
    public static final String TEMPERATURE_KEY = "tempKelvin";

    private ThermoelectricSourceBuilder(Block matching) {
        super((IERecipeSerializer)((Object)ThermoelectricSource.SERIALIZER.get()));
        this.addWriter(obj -> obj.addProperty(SINGLE_BLOCK_KEY, matching.getRegistryName().toString()));
    }

    private ThermoelectricSourceBuilder(TagKey<Block> matching) {
        super((IERecipeSerializer)((Object)ThermoelectricSource.SERIALIZER.get()));
        this.addWriter(obj -> obj.addProperty(BLOCK_TAG_KEY, matching.f_203868_().toString()));
    }

    public static ThermoelectricSourceBuilder builder(TagKey<Block> tag) {
        return new ThermoelectricSourceBuilder(tag);
    }

    public static ThermoelectricSourceBuilder builder(Block blocks) {
        return new ThermoelectricSourceBuilder(blocks);
    }

    public ThermoelectricSourceBuilder kelvin(int temperature) {
        this.addWriter(obj -> obj.addProperty(TEMPERATURE_KEY, (Number)temperature));
        return this;
    }

    public ThermoelectricSourceBuilder celsius(int temperature) {
        return this.kelvin(TemperatureScale.CELSIUS.toKelvin(temperature));
    }

    public ThermoelectricSourceBuilder fahrenheit(int temperature) {
        return this.kelvin(TemperatureScale.FAHRENHEIT.toKelvin(temperature));
    }

    public static enum TemperatureScale {
        KELVIN,
        CELSIUS,
        FAHRENHEIT;


        public int toKelvin(int in) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case KELVIN -> in;
                case CELSIUS -> in + 273;
                case FAHRENHEIT -> (int)Math.round((double)(in - 32) / 1.8 + 273.0);
            };
        }
    }
}

