/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;

public class TagUtils {
    public static boolean isNonemptyItemTag(RegistryAccess tags, ResourceLocation name) {
        return TagUtils.holderStream(tags, Registry.f_122904_, name).findAny().isPresent();
    }

    private static List<ResourceLocation> getTags(Holder.Reference<?> ref) {
        return ref.m_203616_().map(TagKey::f_203868_).toList();
    }

    public static Collection<ResourceLocation> getMatchingTagNames(RegistryAccess tags, ItemStack stack) {
        HashSet<ResourceLocation> ret = new HashSet<ResourceLocation>(TagUtils.getTags(stack.m_41720_().m_204114_()));
        Block b = Block.m_49814_((Item)stack.m_41720_());
        if (b != Blocks.f_50016_) {
            ret.addAll(TagUtils.getTags(b.m_204297_()));
        }
        return ret;
    }

    public static String[] getMatchingPrefixAndRemaining(RegistryAccess tags, ItemStack stack, String ... componentTypes) {
        for (ResourceLocation name : TagUtils.getMatchingTagNames(tags, stack)) {
            for (String componentType : componentTypes) {
                if (!name.m_135815_().startsWith(componentType)) continue;
                String material = name.m_135815_().substring(componentType.length());
                if (material.startsWith("/")) {
                    material = material.substring(1);
                }
                if (material.length() <= 0) continue;
                return new String[]{componentType, material};
            }
        }
        return null;
    }

    public static boolean isIngot(RegistryAccess tags, ItemStack stack) {
        Registry registry = tags.m_175515_(Registry.f_122904_);
        Optional tag = registry.m_203431_(Tags.Items.INGOTS);
        if (tag.isPresent()) {
            return ((HolderSet.Named)tag.get()).m_203333_(Holder.m_205709_((Object)stack.m_41720_()));
        }
        return false;
    }

    public static <T> Stream<T> elementStream(RegistryAccess tags, ResourceKey<Registry<T>> registry, ResourceLocation tag) {
        return TagUtils.holderStream(tags, registry, tag).map(Holder::m_203334_);
    }

    public static <T> Stream<T> elementStream(RegistryAccess tags, TagKey<T> key) {
        return TagUtils.holderStream(tags.m_175515_(key.f_203867_()), key).map(Holder::m_203334_);
    }

    public static <T> Stream<T> elementStream(Registry<T> registry, TagKey<T> tag) {
        return TagUtils.holderStream(registry, tag).map(Holder::m_203334_);
    }

    public static <T> Stream<Holder<T>> holderStream(RegistryAccess tags, ResourceKey<Registry<T>> registry, ResourceLocation tag) {
        return TagUtils.holderStream(tags.m_175515_(registry), TagKey.m_203882_(registry, (ResourceLocation)tag));
    }

    public static <T> Stream<Holder<T>> holderStream(Registry<T> registry, TagKey<T> tag) {
        return StreamSupport.stream(registry.m_206058_(tag).spliterator(), false);
    }

    public static TagKey<Item> createItemWrapper(ResourceLocation name) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)name);
    }

    public static TagKey<Block> createBlockWrapper(ResourceLocation name) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)name);
    }

    public static TagKey<Fluid> createFluidWrapper(ResourceLocation name) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122899_, (ResourceLocation)name);
    }

    public static TagKey<EntityType<?>> createEntityWrapper(ResourceLocation name) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)name);
    }
}

